/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.util;

import com.spotify.styx.util.Time;
import java.time.Instant;
import java.util.Objects;
import java.util.Random;

public class RandomGenerator {
    public static final RandomGenerator DEFAULT = new RandomGenerator(Instant::now);
    private static final Random RANDOM = new Random();
    private static final int BOUND = 100000;
    public final Time time;

    RandomGenerator(Time time) {
        this.time = Objects.requireNonNull(time);
    }

    public String generateNumber() {
        int num = RANDOM.nextInt(100000);
        return String.format("%05d", num);
    }

    public String generateUniqueId(String prefix) {
        return String.format("%s-%013d-%s", prefix, ((Instant)this.time.get()).toEpochMilli(), this.generateNumber());
    }
}

