/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.logging.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;

public class LoggerThresholdFilter
extends Filter<ILoggingEvent> {
    private String logger;
    private Level level;
    private String exceptLogger;

    @Override
    public FilterReply decide(ILoggingEvent event) {
        if (!this.isStarted()) {
            return FilterReply.NEUTRAL;
        }
        if (this.logger != null && !event.getLoggerName().startsWith(this.logger)) {
            return FilterReply.NEUTRAL;
        }
        if (this.exceptLogger != null && event.getLoggerName().startsWith(this.exceptLogger)) {
            return FilterReply.NEUTRAL;
        }
        if (this.level != null && !event.getLevel().isGreaterOrEqual(this.level)) {
            return FilterReply.DENY;
        }
        return FilterReply.NEUTRAL;
    }

    public void setLogger(String logger) {
        this.logger = logger;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public void setExceptLogger(String exceptLogger) {
        this.exceptLogger = exceptLogger;
    }
}

