/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.logging;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.filter.ThresholdFilter;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import com.getsentry.raven.logback.SentryAppender;
import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.spotify.logging.JewelCliLoggingOptions;
import com.spotify.logging.UncaughtExceptionLogger;
import com.spotify.logging.logback.CustomLogstashEncoder;
import com.spotify.logging.logback.MillisecondPrecisionSyslogAppender;
import java.io.File;
import java.lang.management.ManagementFactory;
import org.slf4j.LoggerFactory;

public class LoggingConfigurator {
    public static final String DEFAULT_IDENT = "java";
    public static final String SPOTIFY_HOSTNAME = "SPOTIFY_HOSTNAME";
    public static final String SPOTIFY_SYSLOG_HOST = "SPOTIFY_SYSLOG_HOST";
    public static final String SPOTIFY_SYSLOG_PORT = "SPOTIFY_SYSLOG_PORT";

    public static void configureNoLogging() {
        Logger rootLogger = (Logger)LoggerFactory.getLogger("ROOT");
        LoggerContext context = rootLogger.getLoggerContext();
        context.reset();
        for (Logger logger : context.getLoggerList()) {
            if (logger == rootLogger) continue;
            logger.setLevel(null);
        }
        rootLogger.setLevel(ch.qos.logback.classic.Level.OFF);
    }

    public static void configureDefaults() {
        LoggingConfigurator.configureDefaults(DEFAULT_IDENT);
    }

    public static void configureDefaults(String ident) {
        LoggingConfigurator.configureDefaults(ident, Level.INFO);
    }

    public static void configureDefaults(String ident, Level level) {
        LoggingConfigurator.configureDefaults(ident, level, ReplaceNewLines.OFF);
    }

    public static void configureDefaults(String ident, Level level, ReplaceNewLines replaceNewLines) {
        String syslogHost = LoggingConfigurator.getSyslogHost();
        int syslogPort = LoggingConfigurator.getSyslogPort();
        if (syslogHost != null || syslogPort != -1) {
            LoggingConfigurator.configureSyslogDefaults(ident, level, syslogHost, syslogPort, replaceNewLines);
            return;
        }
        Logger rootLogger = (Logger)LoggerFactory.getLogger("ROOT");
        LoggerContext context = LoggingConfigurator.setupLoggerContext(rootLogger, ident);
        rootLogger.addAppender(LoggingConfigurator.getStdErrAppender(context, replaceNewLines));
        rootLogger.setLevel(level.logbackLevel);
        UncaughtExceptionLogger.setDefaultUncaughtExceptionHandler();
    }

    public static void configureLogstashEncoderDefaults(Level level) {
        Logger rootLogger = (Logger)LoggerFactory.getLogger("ROOT");
        LoggerContext context = rootLogger.getLoggerContext();
        context.reset();
        CustomLogstashEncoder encoder = new CustomLogstashEncoder().setupStackdriver();
        encoder.setContext(context);
        encoder.start();
        ConsoleAppender<ILoggingEvent> appender = new ConsoleAppender<ILoggingEvent>();
        appender.setTarget("System.out");
        appender.setName("stdout");
        appender.setEncoder(encoder);
        appender.setContext(context);
        appender.start();
        rootLogger.addAppender((Appender<ILoggingEvent>)appender);
        rootLogger.setLevel(level.logbackLevel);
        UncaughtExceptionLogger.setDefaultUncaughtExceptionHandler();
    }

    public static void configureSyslogDefaults(String ident) {
        LoggingConfigurator.configureSyslogDefaults(ident, Level.INFO, ReplaceNewLines.OFF);
    }

    public static void configureSyslogDefaults(String ident, Level level, ReplaceNewLines replaceNewLines) {
        String syslogHost = System.getenv(SPOTIFY_SYSLOG_HOST);
        String port = System.getenv(SPOTIFY_SYSLOG_PORT);
        int syslogPort = port == null ? -1 : Integer.valueOf(port);
        LoggingConfigurator.configureSyslogDefaults(ident, level, syslogHost, syslogPort, replaceNewLines);
    }

    public static void configureSyslogDefaults(String ident, Level level, String host, int port, ReplaceNewLines replaceNewLines) {
        LoggingConfigurator.configureSyslogDefaults(ident, level, host, port, "ROOT", replaceNewLines);
    }

    public static void configureSyslogDefaults(String ident, Level level, String host, int port, String loggerName, ReplaceNewLines replaceNewLines) {
        Logger logger = (Logger)LoggerFactory.getLogger(loggerName);
        LoggerContext context = LoggingConfigurator.setupLoggerContext(logger, ident);
        logger.addAppender(LoggingConfigurator.getSyslogAppender(context, host, port, replaceNewLines));
        logger.setLevel(level.logbackLevel);
        UncaughtExceptionLogger.setDefaultUncaughtExceptionHandler();
    }

    public static SentryAppender addSentryAppender(String dsn) {
        return LoggingConfigurator.addSentryAppender(dsn, Level.ERROR);
    }

    public static SentryAppender addSentryAppender(String dsn, Level logLevelThreshold) {
        Logger rootLogger = (Logger)LoggerFactory.getLogger("ROOT");
        LoggerContext context = rootLogger.getLoggerContext();
        SentryAppender appender = new SentryAppender();
        appender.setDsn(dsn);
        appender.setContext(context);
        ThresholdFilter levelFilter = new ThresholdFilter();
        levelFilter.setLevel(logLevelThreshold.logbackLevel.toString());
        levelFilter.start();
        appender.addFilter(levelFilter);
        appender.start();
        rootLogger.addAppender(appender);
        return appender;
    }

    private static Appender<ILoggingEvent> getStdErrAppender(LoggerContext context, ReplaceNewLines replaceNewLines) {
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setContext(context);
        encoder.setPattern("%date{HH:mm:ss.SSS} %property{ident}[%property{pid}]: %-5level [%thread] %logger{0}: " + ReplaceNewLines.getMsgPattern(replaceNewLines) + "%n");
        encoder.setCharset(Charsets.UTF_8);
        encoder.start();
        ConsoleAppender<ILoggingEvent> appender = new ConsoleAppender<ILoggingEvent>();
        appender.setTarget("System.err");
        appender.setName("stderr");
        appender.setEncoder(encoder);
        appender.setContext(context);
        appender.start();
        return appender;
    }

    static Appender<ILoggingEvent> getSyslogAppender(LoggerContext context, String host, int port, ReplaceNewLines replaceNewLines) {
        String h2 = Strings.isNullOrEmpty(host) ? "localhost" : host;
        int p = port < 0 ? 514 : port;
        MillisecondPrecisionSyslogAppender appender = new MillisecondPrecisionSyslogAppender();
        appender.setFacility("LOCAL0");
        appender.setSyslogHost(h2);
        appender.setPort(p);
        appender.setName("syslog");
        appender.setCharset(Charsets.UTF_8);
        appender.setContext(context);
        appender.setSuffixPattern("%property{ident}[%property{pid}]: " + ReplaceNewLines.getMsgPattern(replaceNewLines));
        appender.setStackTracePattern("%property{ident}[%property{pid}]: \t");
        appender.start();
        return appender;
    }

    static void configure(JewelCliLoggingOptions opts) {
        int syslogPort;
        if (!opts.logFileName().isEmpty()) {
            LoggingConfigurator.configure(new File(opts.logFileName()), opts.ident());
            return;
        }
        Logger rootLogger = (Logger)LoggerFactory.getLogger("ROOT");
        UncaughtExceptionLogger.setDefaultUncaughtExceptionHandler();
        LoggerContext context = LoggingConfigurator.setupLoggerContext(rootLogger, opts.ident());
        String syslogHost = opts.syslogHost();
        if (Strings.isNullOrEmpty(syslogHost)) {
            syslogHost = LoggingConfigurator.getSyslogHost();
        }
        if ((syslogPort = opts.syslogPort()) < 0) {
            syslogPort = LoggingConfigurator.getSyslogPort();
        }
        if (opts.syslog() || syslogHost != null || syslogPort > 0) {
            rootLogger.addAppender(LoggingConfigurator.getSyslogAppender(context, syslogHost, syslogPort, ReplaceNewLines.OFF));
        } else {
            rootLogger.addAppender(LoggingConfigurator.getStdErrAppender(context, ReplaceNewLines.OFF));
        }
        rootLogger.setLevel(Level.INFO.logbackLevel);
        if (opts.error()) {
            rootLogger.setLevel(Level.ERROR.logbackLevel);
        }
        if (opts.warn()) {
            rootLogger.setLevel(Level.WARN.logbackLevel);
        }
        if (opts.info()) {
            rootLogger.setLevel(Level.INFO.logbackLevel);
        }
        if (opts.debug()) {
            rootLogger.setLevel(Level.DEBUG.logbackLevel);
        }
        if (opts.trace()) {
            rootLogger.setLevel(Level.TRACE.logbackLevel);
        }
    }

    public static void configure(File file) {
        LoggingConfigurator.configure(file, DEFAULT_IDENT);
    }

    public static void configure(File file, String defaultIdent) {
        String ident;
        Logger rootLogger = (Logger)LoggerFactory.getLogger("ROOT");
        LoggerContext context = rootLogger.getLoggerContext();
        context.reset();
        UncaughtExceptionLogger.setDefaultUncaughtExceptionHandler();
        try {
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext(context);
            configurator.doConfigure(file);
        }
        catch (JoranException configurator) {
            // empty catch block
        }
        context.putProperty("pid", LoggingConfigurator.getMyPid());
        String hostname = LoggingConfigurator.getSpotifyHostname();
        if (hostname != null) {
            context.putProperty("hostname", hostname);
        }
        if ((ident = context.getProperty("ident")) == null) {
            context.putProperty("ident", defaultIdent);
        }
        StatusPrinter.printInCaseOfErrorsOrWarnings(context);
    }

    private static LoggerContext setupLoggerContext(Logger rootLogger, String ident) {
        LoggerContext context = rootLogger.getLoggerContext();
        context.reset();
        context.putProperty("ident", ident);
        context.putProperty("pid", LoggingConfigurator.getMyPid());
        context.putProperty("hostname", LoggingConfigurator.getSpotifyHostname());
        return context;
    }

    private static String getMyPid() {
        String pid = "0";
        try {
            String nameStr = ManagementFactory.getRuntimeMXBean().getName();
            pid = nameStr.split("@")[0];
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return pid;
    }

    private static String getSyslogHost() {
        return Strings.emptyToNull(System.getenv(SPOTIFY_SYSLOG_HOST));
    }

    private static int getSyslogPort() {
        String port = System.getenv(SPOTIFY_SYSLOG_PORT);
        return Strings.isNullOrEmpty(port) ? -1 : Integer.valueOf(port);
    }

    private static String getSpotifyHostname() {
        return Strings.emptyToNull(System.getenv(SPOTIFY_HOSTNAME));
    }

    public static enum Level {
        OFF(ch.qos.logback.classic.Level.OFF),
        ERROR(ch.qos.logback.classic.Level.ERROR),
        WARN(ch.qos.logback.classic.Level.WARN),
        INFO(ch.qos.logback.classic.Level.INFO),
        DEBUG(ch.qos.logback.classic.Level.DEBUG),
        TRACE(ch.qos.logback.classic.Level.TRACE),
        ALL(ch.qos.logback.classic.Level.ALL);

        final ch.qos.logback.classic.Level logbackLevel;

        private Level(ch.qos.logback.classic.Level logbackLevel) {
            this.logbackLevel = logbackLevel;
        }
    }

    public static enum ReplaceNewLines {
        OFF,
        ON;


        public static String getMsgPattern(ReplaceNewLines replaceNewLines) {
            return replaceNewLines == ON ? "%replace(%msg){'[\\r\\n]', ''}" : "%msg";
        }
    }
}

