/*
 * Decompiled with CFR 0.152.
 */
package com.getsentry.raven.event.interfaces;

import com.getsentry.raven.event.interfaces.SentryInterface;
import java.util.Arrays;

public class StackTraceInterface
implements SentryInterface {
    public static final String STACKTRACE_INTERFACE = "sentry.interfaces.Stacktrace";
    private final StackTraceElement[] stackTrace;
    private final int framesCommonWithEnclosing;

    public StackTraceInterface(StackTraceElement[] stackTrace) {
        this(stackTrace, new StackTraceElement[0]);
    }

    public StackTraceInterface(StackTraceElement[] stackTrace, StackTraceElement[] enclosingStackTrace) {
        this.stackTrace = Arrays.copyOf(stackTrace, stackTrace.length);
        int m3 = stackTrace.length - 1;
        for (int n = enclosingStackTrace.length - 1; m3 >= 0 && n >= 0 && stackTrace[m3].equals(enclosingStackTrace[n]); --m3, --n) {
        }
        this.framesCommonWithEnclosing = stackTrace.length - 1 - m3;
    }

    @Override
    public String getInterfaceName() {
        return STACKTRACE_INTERFACE;
    }

    public StackTraceElement[] getStackTrace() {
        return Arrays.copyOf(this.stackTrace, this.stackTrace.length);
    }

    public int getFramesCommonWithEnclosing() {
        return this.framesCommonWithEnclosing;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StackTraceInterface that = (StackTraceInterface)o;
        return Arrays.equals(this.stackTrace, that.stackTrace);
    }

    public int hashCode() {
        return Arrays.hashCode(this.stackTrace);
    }

    public String toString() {
        return "StackTraceInterface{stackTrace=" + Arrays.toString(this.stackTrace) + '}';
    }
}

