/*
 * Decompiled with CFR 0.152.
 */
package com.getsentry.raven;

import com.getsentry.raven.Raven;
import com.getsentry.raven.RavenFactory;
import com.getsentry.raven.buffer.Buffer;
import com.getsentry.raven.buffer.DiskBuffer;
import com.getsentry.raven.connection.AsyncConnection;
import com.getsentry.raven.connection.BufferedConnection;
import com.getsentry.raven.connection.Connection;
import com.getsentry.raven.connection.HttpConnection;
import com.getsentry.raven.connection.NoopConnection;
import com.getsentry.raven.connection.OutputStreamConnection;
import com.getsentry.raven.connection.RandomEventSampler;
import com.getsentry.raven.dsn.Dsn;
import com.getsentry.raven.event.helper.ContextBuilderHelper;
import com.getsentry.raven.event.helper.HttpEventBuilderHelper;
import com.getsentry.raven.event.interfaces.ExceptionInterface;
import com.getsentry.raven.event.interfaces.HttpInterface;
import com.getsentry.raven.event.interfaces.MessageInterface;
import com.getsentry.raven.event.interfaces.StackTraceInterface;
import com.getsentry.raven.event.interfaces.UserInterface;
import com.getsentry.raven.marshaller.Marshaller;
import com.getsentry.raven.marshaller.json.ExceptionInterfaceBinding;
import com.getsentry.raven.marshaller.json.HttpInterfaceBinding;
import com.getsentry.raven.marshaller.json.JsonMarshaller;
import com.getsentry.raven.marshaller.json.MessageInterfaceBinding;
import com.getsentry.raven.marshaller.json.StackTraceInterfaceBinding;
import com.getsentry.raven.marshaller.json.UserInterfaceBinding;
import com.getsentry.raven.util.Util;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRavenFactory
extends RavenFactory {
    public static final String NAIVE_PROTOCOL = "naive";
    public static final String COMPRESSION_OPTION = "raven.compression";
    public static final String MAX_MESSAGE_LENGTH_OPTION = "raven.maxmessagelength";
    public static final String TIMEOUT_OPTION = "raven.timeout";
    public static final int TIMEOUT_DEFAULT = (int)TimeUnit.SECONDS.toMillis(1L);
    public static final String BUFFER_DIR_OPTION = "raven.buffer.dir";
    public static final String BUFFER_SIZE_OPTION = "raven.buffer.size";
    public static final int BUFFER_SIZE_DEFAULT = 50;
    public static final String BUFFER_FLUSHTIME_OPTION = "raven.buffer.flushtime";
    public static final long BUFFER_FLUSHTIME_DEFAULT = 60000L;
    public static final String BUFFER_GRACEFUL_SHUTDOWN_OPTION = "raven.buffer.gracefulshutdown";
    public static final String BUFFER_SHUTDOWN_TIMEOUT_OPTION = "raven.buffer.shutdowntimeout";
    public static final long BUFFER_SHUTDOWN_TIMEOUT_DEFAULT = TimeUnit.SECONDS.toMillis(1L);
    public static final String ASYNC_OPTION = "raven.async";
    public static final String ASYNC_GRACEFUL_SHUTDOWN_OPTION = "raven.async.gracefulshutdown";
    public static final String ASYNC_THREADS_OPTION = "raven.async.threads";
    public static final String ASYNC_PRIORITY_OPTION = "raven.async.priority";
    public static final String ASYNC_QUEUE_SIZE_OPTION = "raven.async.queuesize";
    public static final String ASYNC_QUEUE_OVERFLOW_OPTION = "raven.async.queue.overflow";
    public static final String ASYNC_QUEUE_DISCARDOLD = "discardold";
    public static final String ASYNC_QUEUE_DISCARDNEW = "discardnew";
    public static final String ASYNC_QUEUE_SYNC = "sync";
    public static final String ASYNC_QUEUE_OVERFLOW_DEFAULT = "discardold";
    public static final String ASYNC_SHUTDOWN_TIMEOUT_OPTION = "raven.async.shutdowntimeout";
    public static final long ASYNC_SHUTDOWN_TIMEOUT_DEFAULT = TimeUnit.SECONDS.toMillis(1L);
    public static final String HIDE_COMMON_FRAMES_OPTION = "raven.stacktrace.hidecommon";
    public static final String SAMPLE_RATE_OPTION = "raven.sample.rate";
    public static final String HTTP_PROXY_HOST_OPTION = "raven.http.proxy.host";
    public static final String HTTP_PROXY_PORT_OPTION = "raven.http.proxy.port";
    public static final int QUEUE_SIZE_DEFAULT = 50;
    public static final int HTTP_PROXY_PORT_DEFAULT = 80;
    private static final Logger logger = LoggerFactory.getLogger(DefaultRavenFactory.class);
    private static final String FALSE = Boolean.FALSE.toString();
    private static final Map<String, RejectedExecutionHandler> REJECT_EXECUTION_HANDLERS = new HashMap<String, RejectedExecutionHandler>();

    @Override
    public Raven createRavenInstance(Dsn dsn) {
        Raven raven = new Raven(this.createConnection(dsn));
        try {
            Class.forName("javax.servlet.ServletRequestListener", false, this.getClass().getClassLoader());
            raven.addBuilderHelper(new HttpEventBuilderHelper());
        }
        catch (ClassNotFoundException e) {
            logger.debug("The current environment doesn't provide access to servlets,or provides an unsupported version.");
        }
        raven.addBuilderHelper(new ContextBuilderHelper(raven));
        return raven;
    }

    protected Connection createConnection(Dsn dsn) {
        Connection connection;
        String protocol = dsn.getProtocol();
        if (protocol.equalsIgnoreCase("http") || protocol.equalsIgnoreCase("https")) {
            logger.info("Using an HTTP connection to Sentry.");
            connection = this.createHttpConnection(dsn);
        } else if (protocol.equalsIgnoreCase("out")) {
            logger.info("Using StdOut to send events.");
            connection = this.createStdOutConnection(dsn);
        } else if (protocol.equalsIgnoreCase("noop")) {
            logger.info("Using noop to send events.");
            connection = new NoopConnection();
        } else {
            throw new IllegalStateException("Couldn't create a connection for the protocol '" + protocol + "'");
        }
        Buffer eventBuffer = this.getBuffer(dsn);
        if (eventBuffer != null) {
            long flushtime = this.getBufferFlushtime(dsn);
            boolean gracefulShutdown = this.getBufferedConnectionGracefulShutdownEnabled(dsn);
            Long shutdownTimeout = this.getBufferedConnectionShutdownTimeout(dsn);
            connection = new BufferedConnection(connection, eventBuffer, flushtime, gracefulShutdown, shutdownTimeout);
        }
        if (this.getAsyncEnabled(dsn)) {
            connection = this.createAsyncConnection(dsn, connection);
        }
        return connection;
    }

    protected Connection createAsyncConnection(Dsn dsn, Connection connection) {
        int maxThreads = this.getAsyncThreads(dsn);
        int priority = this.getAsyncPriority(dsn);
        int queueSize = this.getAsyncQueueSize(dsn);
        LinkedBlockingDeque<Runnable> queue = queueSize == -1 ? new LinkedBlockingDeque<Runnable>() : new LinkedBlockingDeque(queueSize);
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(maxThreads, maxThreads, 0L, TimeUnit.MILLISECONDS, queue, new DaemonThreadFactory(priority), this.getRejectedExecutionHandler(dsn));
        boolean gracefulShutdown = this.getAsyncGracefulShutdownEnabled(dsn);
        long shutdownTimeout = this.getAsyncShutdownTimeout(dsn);
        return new AsyncConnection(connection, executorService, gracefulShutdown, shutdownTimeout);
    }

    protected Connection createHttpConnection(Dsn dsn) {
        URL sentryApiUrl = HttpConnection.getSentryApiUrl(dsn.getUri(), dsn.getProjectId());
        String proxyHost = this.getProxyHost(dsn);
        int proxyPort = this.getProxyPort(dsn);
        Proxy proxy = null;
        if (proxyHost != null) {
            InetSocketAddress proxyAddr = new InetSocketAddress(proxyHost, proxyPort);
            proxy = new Proxy(Proxy.Type.HTTP, proxyAddr);
        }
        Double sampleRate = this.getSampleRate(dsn);
        RandomEventSampler eventSampler = null;
        if (sampleRate != null) {
            eventSampler = new RandomEventSampler(sampleRate);
        }
        HttpConnection httpConnection = new HttpConnection(sentryApiUrl, dsn.getPublicKey(), dsn.getSecretKey(), proxy, eventSampler);
        Marshaller marshaller = this.createMarshaller(dsn);
        httpConnection.setMarshaller(marshaller);
        int timeout = this.getTimeout(dsn);
        httpConnection.setTimeout(timeout);
        boolean bypassSecurityEnabled = this.getBypassSecurityEnabled(dsn);
        httpConnection.setBypassSecurity(bypassSecurityEnabled);
        return httpConnection;
    }

    protected Connection createStdOutConnection(Dsn dsn) {
        OutputStreamConnection stdOutConnection = new OutputStreamConnection(System.out);
        stdOutConnection.setMarshaller(this.createMarshaller(dsn));
        return stdOutConnection;
    }

    protected Marshaller createMarshaller(Dsn dsn) {
        int maxMessageLength = this.getMaxMessageLength(dsn);
        JsonMarshaller marshaller = new JsonMarshaller(maxMessageLength);
        StackTraceInterfaceBinding stackTraceBinding = new StackTraceInterfaceBinding();
        stackTraceBinding.setRemoveCommonFramesWithEnclosing(this.getHideCommonFramesEnabled(dsn));
        stackTraceBinding.setNotInAppFrames(this.getNotInAppFrames());
        marshaller.addInterfaceBinding(StackTraceInterface.class, stackTraceBinding);
        marshaller.addInterfaceBinding(ExceptionInterface.class, new ExceptionInterfaceBinding(stackTraceBinding));
        marshaller.addInterfaceBinding(MessageInterface.class, new MessageInterfaceBinding(maxMessageLength));
        marshaller.addInterfaceBinding(UserInterface.class, new UserInterfaceBinding());
        HttpInterfaceBinding httpBinding = new HttpInterfaceBinding();
        marshaller.addInterfaceBinding(HttpInterface.class, httpBinding);
        marshaller.setCompression(this.getCompressionEnabled(dsn));
        return marshaller;
    }

    protected Collection<String> getNotInAppFrames() {
        return Arrays.asList("com.sun.", "java.", "javax.", "org.omg.", "sun.", "junit.", "com.intellij.rt.");
    }

    protected boolean getAsyncEnabled(Dsn dsn) {
        return !FALSE.equalsIgnoreCase(dsn.getOptions().get(ASYNC_OPTION));
    }

    protected RejectedExecutionHandler getRejectedExecutionHandler(Dsn dsn) {
        RejectedExecutionHandler handler;
        String overflowName = "discardold";
        if (dsn.getOptions().containsKey(ASYNC_QUEUE_OVERFLOW_OPTION)) {
            overflowName = dsn.getOptions().get(ASYNC_QUEUE_OVERFLOW_OPTION).toLowerCase();
        }
        if ((handler = REJECT_EXECUTION_HANDLERS.get(overflowName)) == null) {
            String options = Arrays.toString(REJECT_EXECUTION_HANDLERS.keySet().toArray());
            throw new RuntimeException("RejectedExecutionHandler not found: '" + overflowName + "', valid choices are: " + options);
        }
        return handler;
    }

    protected long getBufferedConnectionShutdownTimeout(Dsn dsn) {
        return Util.parseLong(dsn.getOptions().get(BUFFER_SHUTDOWN_TIMEOUT_OPTION), BUFFER_SHUTDOWN_TIMEOUT_DEFAULT);
    }

    protected boolean getBufferedConnectionGracefulShutdownEnabled(Dsn dsn) {
        return !FALSE.equalsIgnoreCase(dsn.getOptions().get(BUFFER_GRACEFUL_SHUTDOWN_OPTION));
    }

    protected long getBufferFlushtime(Dsn dsn) {
        return Util.parseLong(dsn.getOptions().get(BUFFER_FLUSHTIME_OPTION), 60000L);
    }

    protected long getAsyncShutdownTimeout(Dsn dsn) {
        return Util.parseLong(dsn.getOptions().get(ASYNC_SHUTDOWN_TIMEOUT_OPTION), ASYNC_SHUTDOWN_TIMEOUT_DEFAULT);
    }

    protected boolean getAsyncGracefulShutdownEnabled(Dsn dsn) {
        return !FALSE.equalsIgnoreCase(dsn.getOptions().get(ASYNC_GRACEFUL_SHUTDOWN_OPTION));
    }

    protected int getAsyncQueueSize(Dsn dsn) {
        return Util.parseInteger(dsn.getOptions().get(ASYNC_QUEUE_SIZE_OPTION), 50);
    }

    protected int getAsyncPriority(Dsn dsn) {
        return Util.parseInteger(dsn.getOptions().get(ASYNC_PRIORITY_OPTION), 1);
    }

    protected int getAsyncThreads(Dsn dsn) {
        return Util.parseInteger(dsn.getOptions().get(ASYNC_THREADS_OPTION), Runtime.getRuntime().availableProcessors());
    }

    protected boolean getBypassSecurityEnabled(Dsn dsn) {
        return dsn.getProtocolSettings().contains(NAIVE_PROTOCOL);
    }

    protected Double getSampleRate(Dsn dsn) {
        return Util.parseDouble(dsn.getOptions().get(SAMPLE_RATE_OPTION), null);
    }

    protected int getProxyPort(Dsn dsn) {
        return Util.parseInteger(dsn.getOptions().get(HTTP_PROXY_PORT_OPTION), 80);
    }

    protected String getProxyHost(Dsn dsn) {
        return dsn.getOptions().get(HTTP_PROXY_HOST_OPTION);
    }

    protected boolean getCompressionEnabled(Dsn dsn) {
        return !FALSE.equalsIgnoreCase(dsn.getOptions().get(COMPRESSION_OPTION));
    }

    protected boolean getHideCommonFramesEnabled(Dsn dsn) {
        return !FALSE.equalsIgnoreCase(dsn.getOptions().get(HIDE_COMMON_FRAMES_OPTION));
    }

    protected int getMaxMessageLength(Dsn dsn) {
        return Util.parseInteger(dsn.getOptions().get(MAX_MESSAGE_LENGTH_OPTION), 1000);
    }

    protected int getTimeout(Dsn dsn) {
        return Util.parseInteger(dsn.getOptions().get(TIMEOUT_OPTION), TIMEOUT_DEFAULT);
    }

    protected Buffer getBuffer(Dsn dsn) {
        String bufferDir = dsn.getOptions().get(BUFFER_DIR_OPTION);
        if (bufferDir != null) {
            return new DiskBuffer(new File(bufferDir), this.getBufferSize(dsn));
        }
        return null;
    }

    protected int getBufferSize(Dsn dsn) {
        return Util.parseInteger(dsn.getOptions().get(BUFFER_SIZE_OPTION), 50);
    }

    static {
        REJECT_EXECUTION_HANDLERS.put(ASYNC_QUEUE_SYNC, new ThreadPoolExecutor.CallerRunsPolicy());
        REJECT_EXECUTION_HANDLERS.put(ASYNC_QUEUE_DISCARDNEW, new ThreadPoolExecutor.DiscardPolicy());
        REJECT_EXECUTION_HANDLERS.put("discardold", new ThreadPoolExecutor.DiscardOldestPolicy());
    }

    protected static final class DaemonThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;
        private final int priority;

        private DaemonThreadFactory(int priority) {
            SecurityManager s2 = System.getSecurityManager();
            this.group = s2 != null ? s2.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "raven-pool-" + POOL_NUMBER.getAndIncrement() + "-thread-";
            this.priority = priority;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (!t.isDaemon()) {
                t.setDaemon(true);
            }
            if (t.getPriority() != this.priority) {
                t.setPriority(this.priority);
            }
            return t;
        }
    }
}

