/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.spark.bigquery;

import com.databricks.spark.avro.SchemaConverters$;
import com.google.api.services.bigquery.model.TableReference;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystem;
import com.google.cloud.hadoop.io.bigquery.AvroBigQueryInputFormat;
import com.google.cloud.hadoop.io.bigquery.BigQueryConfiguration;
import com.google.cloud.hadoop.io.bigquery.BigQueryStrings;
import com.spotify.spark.bigquery.BigQueryClient;
import com.spotify.spark.bigquery.BigQueryClient$;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Serializable;
import scala.Tuple2;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b\u0001B\u0001\u0003\u0001-\u0011!CQ5h#V,'/_*R\u0019\u000e{g\u000e^3yi*\u00111\u0001B\u0001\tE&<\u0017/^3ss*\u0011QAB\u0001\u0006gB\f'o\u001b\u0006\u0003\u000f!\tqa\u001d9pi&4\u0017PC\u0001\n\u0003\r\u0019w.\\\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\u0005\t'\u0001\u0011\t\u0011)A\u0005)\u0005Q1/\u001d7D_:$X\r\u001f;\u0011\u0005UiR\"\u0001\f\u000b\u0005]A\u0012aA:rY*\u0011Q!\u0007\u0006\u00035m\ta!\u00199bG\",'\"\u0001\u000f\u0002\u0007=\u0014x-\u0003\u0002\u001f-\tQ1+\u0015'D_:$X\r\u001f;\t\u000b\u0001\u0002A\u0011A\u0011\u0002\rqJg.\u001b;?)\t\u0011C\u0005\u0005\u0002$\u00015\t!\u0001C\u0003\u0014?\u0001\u0007A\u0003C\u0004'\u0001\t\u0007I\u0011A\u0014\u0002\u0005M\u001cW#\u0001\u0015\u0011\u0005%RS\"\u0001\r\n\u0005-B\"\u0001D*qCJ\\7i\u001c8uKb$\bBB\u0017\u0001A\u0003%\u0001&A\u0002tG\u0002Bqa\f\u0001C\u0002\u0013\u0005\u0001'\u0001\u0003d_:4W#A\u0019\u0011\u0005I2T\"A\u001a\u000b\u0005=\"$BA\u001b\u001a\u0003\u0019A\u0017\rZ8pa&\u0011qg\r\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\re\u0002\u0001\u0015!\u00032\u0003\u0015\u0019wN\u001c4!\u0011!Y\u0004\u0001#b\u0001\n\u0003a\u0014A\u00012r+\u0005i\u0004CA\u0012?\u0013\ty$A\u0001\bCS\u001e\fV/\u001a:z\u00072LWM\u001c;\t\u0011\u0005\u0003\u0001\u0012!Q!\nu\n1AY9!\u0011\u0015\u0019\u0005\u0001\"\u0001E\u0003Q\u0019X\r\u001e\"jOF+XM]=Qe>TWm\u0019;JIR\u0011Q\t\u0013\t\u0003\u001b\u0019K!a\u0012\b\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0013\n\u0003\rAS\u0001\naJ|'.Z2u\u0013\u0012\u0004\"a\u0013(\u000f\u00055a\u0015BA'\u000f\u0003\u0019\u0001&/\u001a3fM&\u0011q\n\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u00055s\u0001\"\u0002*\u0001\t\u0003\u0019\u0016\u0001F:fi\nKw-U;fef<5m\u001d\"vG.,G\u000f\u0006\u0002F)\")Q+\u0015a\u0001\u0015\u0006IqmY:Ck\u000e\\W\r\u001e\u0005\u0006/\u0002!\t\u0001W\u0001\u001bg\u0016$()[4Rk\u0016\u0014\u0018\u0010R1uCN,G\u000fT8dCRLwN\u001c\u000b\u0003\u000bfCQA\u0017,A\u0002)\u000b\u0001\u0002\\8dCRLwN\u001c\u0005\u00069\u0002!\t!X\u0001\u0012g\u0016$xi\u00199Kg>t7*Z=GS2,GCA#_\u0011\u0015y6\f1\u0001K\u0003-Q7o\u001c8LKf4\u0015\u000e\\3\t\u000b\u0005\u0004A\u0011\u00012\u0002#M,GoR2q!.\f$gS3z\r&dW\r\u0006\u0002FG\")A\r\u0019a\u0001\u0015\u0006Y\u0001o[\u00193\u0017\u0016Lh)\u001b7f\u0011\u00151\u0007\u0001\"\u0001h\u00039\u0011\u0017nZ)vKJL8+\u001a7fGR$\"\u0001\u001b>\u0011\u0005%<hB\u00016v\u001d\tYGO\u0004\u0002mg:\u0011QN\u001d\b\u0003]Fl\u0011a\u001c\u0006\u0003a*\ta\u0001\u0010:p_Rt\u0014\"\u0001\u000f\n\u0005iY\u0012BA\u0003\u001a\u0013\t9\u0002$\u0003\u0002w-\u00059\u0001/Y2lC\u001e,\u0017B\u0001=z\u0005%!\u0015\r^1Ge\u0006lWM\u0003\u0002w-!)10\u001aa\u0001\u0015\u0006A1/\u001d7Rk\u0016\u0014\u0018\u0010C\u0003~\u0001\u0011\u0005a0A\u0007cS\u001e\fV/\u001a:z)\u0006\u0014G.\u001a\u000b\u0003Q~Dq!!\u0001}\u0001\u0004\t\u0019!\u0001\u0005uC\ndWMU3g!\u0011\t)!!\u0007\u000e\u0005\u0005\u001d!\u0002BA\u0005\u0003\u0017\tQ!\\8eK2T1aAA\u0007\u0015\u0011\ty!!\u0005\u0002\u0011M,'O^5dKNTA!a\u0005\u0002\u0016\u0005\u0019\u0011\r]5\u000b\u0007\u0005]\u0001\"\u0001\u0004h_><G.Z\u0005\u0005\u00037\t9A\u0001\bUC\ndWMU3gKJ,gnY3\t\ru\u0004A\u0011AA\u0010)\rA\u0017\u0011\u0005\u0005\b\u0003G\ti\u00021\u0001K\u0003%!\u0018M\u00197f'B,7\r")
public class BigQuerySQLContext {
    private final SQLContext sqlContext;
    private final SparkContext sc;
    private final Configuration conf;
    private BigQueryClient bq;
    private volatile boolean bitmap$0;

    private BigQueryClient bq$lzycompute() {
        BigQuerySQLContext bigQuerySQLContext = this;
        synchronized (bigQuerySQLContext) {
            if (!this.bitmap$0) {
                this.bq = BigQueryClient$.MODULE$.getInstance(this.conf());
                this.bitmap$0 = true;
            }
            return this.bq;
        }
    }

    public SparkContext sc() {
        return this.sc;
    }

    public Configuration conf() {
        return this.conf;
    }

    public BigQueryClient bq() {
        return this.bitmap$0 ? this.bq : this.bq$lzycompute();
    }

    public void setBigQueryProjectId(String projectId) {
        this.conf().set("mapred.bq.project.id", projectId);
        if (this.conf().get("fs.gs.project.id") == null) {
            this.conf().set("fs.gs.project.id", projectId);
        }
    }

    public void setBigQueryGcsBucket(String gcsBucket) {
        this.conf().set("mapred.bq.gcs.bucket", gcsBucket);
    }

    public void setBigQueryDatasetLocation(String location) {
        this.conf().set(BigQueryClient$.MODULE$.STAGING_DATASET_LOCATION(), location);
    }

    public void setGcpJsonKeyFile(String jsonKeyFile) {
        this.conf().set("mapred.bq.auth.service.account.json.keyfile", jsonKeyFile);
        this.conf().set("fs.gs.auth.service.account.json.keyfile", jsonKeyFile);
    }

    public void setGcpPk12KeyFile(String pk12KeyFile) {
        this.conf().set("google.cloud.auth.service.account.keyfile", pk12KeyFile);
        this.conf().set("mapred.bq.auth.service.account.keyfile", pk12KeyFile);
        this.conf().set("fs.gs.auth.service.account.keyfile", pk12KeyFile);
    }

    public Dataset<Row> bigQuerySelect(String sqlQuery) {
        return this.bigQueryTable(this.bq().query(sqlQuery));
    }

    public Dataset<Row> bigQueryTable(TableReference tableRef) {
        this.conf().setClass("mapreduce.inputformat.class", AvroBigQueryInputFormat.class, InputFormat.class);
        BigQueryConfiguration.configureBigQueryInput((Configuration)this.conf(), (String)tableRef.getProjectId(), (String)tableRef.getDatasetId(), (String)tableRef.getTableId());
        Class<AvroBigQueryInputFormat> fClass = AvroBigQueryInputFormat.class;
        Class<LongWritable> kClass = LongWritable.class;
        Class<GenericData.Record> vClass = GenericData.Record.class;
        RDD rdd = this.sc().newAPIHadoopRDD(this.conf(), fClass, kClass, vClass).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final GenericData.Record apply(Tuple2<LongWritable, GenericData.Record> x$1) {
                return (GenericData.Record)x$1._2();
            }
        }, ClassTag$.MODULE$.apply(GenericData.Record.class));
        String schemaString = (String)rdd.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(GenericData.Record x$2) {
                return x$2.getSchema().toString();
            }
        }, ClassTag$.MODULE$.apply(String.class)).first();
        Schema schema = new Schema.Parser().parse(schemaString);
        StructType structType = (StructType)SchemaConverters$.MODULE$.toSqlType(schema).dataType();
        Function1<Object, Object> converter = SchemaConverters$.MODULE$.createConverterToSQL(schema, (DataType)structType);
        return this.sqlContext.createDataFrame(rdd.map(converter, ClassTag$.MODULE$.apply(Row.class)), structType);
    }

    public Dataset<Row> bigQueryTable(String tableSpec) {
        return this.bigQueryTable(BigQueryStrings.parseTableReference((String)tableSpec));
    }

    public BigQuerySQLContext(SQLContext sqlContext) {
        this.sqlContext = sqlContext;
        this.sc = sqlContext.sparkContext();
        this.conf = this.sc().hadoopConfiguration();
        if (this.conf().get("fs.gs.impl") == null) {
            this.conf().set("fs.gs.impl", GoogleHadoopFileSystem.class.getName());
        }
    }
}

