/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.spark.bigquery;

import com.databricks.spark.avro.package$;
import com.google.api.services.bigquery.model.TableReference;
import com.google.cloud.hadoop.io.bigquery.BigQueryStrings;
import com.spotify.spark.bigquery.BigQueryClient;
import com.spotify.spark.bigquery.BigQueryClient$;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import scala.Enumeration;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0005ub\u0001B\u0001\u0003\u0001-\u0011\u0011CQ5h#V,'/\u001f#bi\u00064%/Y7f\u0015\t\u0019A!\u0001\u0005cS\u001e\fX/\u001a:z\u0015\t)a!A\u0003ta\u0006\u00148N\u0003\u0002\b\u0011\u000591\u000f]8uS\u001aL(\"A\u0005\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001a\u0001CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0003\u0005\u0014\u0001\t\u0005\t\u0015!\u0003\u0015\u0003\t!g\r\u0005\u0002\u0016U9\u0011ac\n\b\u0003/\u0011r!\u0001\u0007\u0012\u000f\u0005eybB\u0001\u000e\u001e\u001b\u0005Y\"B\u0001\u000f\u000b\u0003\u0019a$o\\8u}%\ta$A\u0002pe\u001eL!\u0001I\u0011\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0012BA\u0003$\u0015\t\u0001\u0013%\u0003\u0002&M\u0005\u00191/\u001d7\u000b\u0005\u0015\u0019\u0013B\u0001\u0015*\u0003\u001d\u0001\u0018mY6bO\u0016T!!\n\u0014\n\u0005-b#!\u0003#bi\u00064%/Y7f\u0015\tA\u0013\u0006C\u0003/\u0001\u0011\u0005q&\u0001\u0004=S:LGO\u0010\u000b\u0003aI\u0002\"!\r\u0001\u000e\u0003\tAQaE\u0017A\u0002QAq\u0001\u000e\u0001C\u0002\u0013\u0005Q'\u0001\u0006tc2\u001cuN\u001c;fqR,\u0012A\u000e\t\u0003oaj\u0011!K\u0005\u0003s%\u0012!bU)M\u0007>tG/\u001a=u\u0011\u0019Y\u0004\u0001)A\u0005m\u0005Y1/\u001d7D_:$X\r\u001f;!\u0011\u001di\u0004A1A\u0005\u0002y\nAaY8oMV\tq\b\u0005\u0002A\t6\t\u0011I\u0003\u0002>\u0005*\u00111iI\u0001\u0007Q\u0006$wn\u001c9\n\u0005\u0015\u000b%!D\"p]\u001aLw-\u001e:bi&|g\u000e\u0003\u0004H\u0001\u0001\u0006IaP\u0001\u0006G>tg\r\t\u0005\b\u0013\u0002\u0011\r\u0011\"\u0001K\u0003\t\u0011\u0017/F\u0001L!\t\tD*\u0003\u0002N\u0005\tq!)[4Rk\u0016\u0014\u0018p\u00117jK:$\bBB(\u0001A\u0003%1*A\u0002cc\u0002BQ!\u0015\u0001\u0005\u0002I\u000b1c]1wK\u0006\u001b()[4Rk\u0016\u0014\u0018\u0010V1cY\u0016$Ba\u0015,f_B\u0011Q\u0002V\u0005\u0003+:\u0011A!\u00168ji\")q\u000b\u0015a\u00011\u0006AA/\u00192mKJ+g\r\u0005\u0002ZG6\t!L\u0003\u0002\\9\u0006)Qn\u001c3fY*\u00111!\u0018\u0006\u0003=~\u000b\u0001b]3sm&\u001cWm\u001d\u0006\u0003A\u0006\f1!\u00199j\u0015\t\u0011\u0007\"\u0001\u0004h_><G.Z\u0005\u0003Ij\u0013a\u0002V1cY\u0016\u0014VMZ3sK:\u001cW\rC\u0003g!\u0002\u0007q-\u0001\txe&$X\rR5ta>\u001c\u0018\u000e^5p]B\u0011\u0001n\u001b\b\u0003c%L!A\u001b\u0002\u0002!]\u0013\u0018\u000e^3ESN\u0004xn]5uS>t\u0017B\u00017n\u0005\u00151\u0016\r\\;f\u0013\tqgBA\u0006F]VlWM]1uS>t\u0007\"\u00029Q\u0001\u0004\t\u0018!E2sK\u0006$X\rR5ta>\u001c\u0018\u000e^5p]B\u0011!o\u001b\b\u0003cML!\u0001\u001e\u0002\u0002#\r\u0013X-\u0019;f\t&\u001c\bo\\:ji&|g\u000eC\u0003R\u0001\u0011\u0005a\u000f\u0006\u0004To\u0006\u0005\u00111\u0001\u0005\u0006qV\u0004\r!_\u0001\ni\u0006\u0014G.Z*qK\u000e\u0004\"A_?\u000f\u00055Y\u0018B\u0001?\u000f\u0003\u0019\u0001&/\u001a3fM&\u0011ap \u0002\u0007'R\u0014\u0018N\\4\u000b\u0005qt\u0001b\u00024v!\u0003\u0005\ra\u001a\u0005\baV\u0004\n\u00111\u0001r\u0011\u001d\t9\u0001\u0001C\u0005\u0003\u0013\ta\u0001Z3mKR,GcA*\u0002\f!A\u0011QBA\u0003\u0001\u0004\ty!\u0001\u0003qCRD\u0007\u0003BA\t\u0003/i!!a\u0005\u000b\u0007\u0005U!)\u0001\u0002gg&!\u0011\u0011DA\n\u0005\u0011\u0001\u0016\r\u001e5\t\u0013\u0005u\u0001!%A\u0005\u0002\u0005}\u0011!H:bm\u0016\f5OQ5h#V,'/\u001f+bE2,G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\u0005\"fA4\u0002$-\u0012\u0011Q\u0005\t\u0005\u0003O\t\t$\u0004\u0002\u0002*)!\u00111FA\u0017\u0003%)hn\u00195fG.,GMC\u0002\u000209\t!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019$!\u000b\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u00028\u0001\t\n\u0011\"\u0001\u0002:\u0005i2/\u0019<f\u0003N\u0014\u0015nZ)vKJLH+\u00192mK\u0012\"WMZ1vYR$3'\u0006\u0002\u0002<)\u001a\u0011/a\t")
public class BigQueryDataFrame {
    private final Dataset<Row> df;
    private final SQLContext sqlContext;
    private final Configuration conf;
    private final BigQueryClient bq;

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public Configuration conf() {
        return this.conf;
    }

    public BigQueryClient bq() {
        return this.bq;
    }

    public void saveAsBigQueryTable(TableReference tableRef, Enumeration.Value writeDisposition, Enumeration.Value createDisposition) {
        String bucket = this.conf().get("mapred.bq.gcs.bucket");
        String temp = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark-bigquery-", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)System.currentTimeMillis()), BoxesRunTime.boxToInteger((int)Random$.MODULE$.nextInt(Integer.MAX_VALUE))}));
        String gcsPath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"gs://", "/hadoop/tmp/spark-bigquery/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bucket, temp}));
        package$.MODULE$.AvroDataFrameWriter(this.df.write()).avro().apply((Object)gcsPath);
        this.bq().load(gcsPath, tableRef, writeDisposition, createDisposition);
        BoxedUnit fdf = BoxedUnit.UNIT;
        this.delete(new Path(gcsPath));
    }

    public void saveAsBigQueryTable(String tableSpec, Enumeration.Value writeDisposition, Enumeration.Value createDisposition) {
        this.saveAsBigQueryTable(BigQueryStrings.parseTableReference((String)tableSpec), writeDisposition, createDisposition);
    }

    public Enumeration.Value saveAsBigQueryTable$default$2() {
        return null;
    }

    public Enumeration.Value saveAsBigQueryTable$default$3() {
        return null;
    }

    private void delete(Path path) {
        FileSystem fs = FileSystem.get((URI)path.toUri(), (Configuration)this.conf());
        fs.delete(path, true);
    }

    public BigQueryDataFrame(Dataset<Row> df) {
        this.df = df;
        this.sqlContext = df.sqlContext();
        this.conf = this.sqlContext().sparkContext().hadoopConfiguration();
        this.bq = BigQueryClient$.MODULE$.getInstance(this.conf());
        this.sqlContext().setConf("spark.sql.avro.compression.codec", "deflate");
    }
}

