/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.hamcrest.optional;

import java.util.Optional;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

class PresentOptional<T>
extends TypeSafeDiagnosingMatcher<Optional<? extends T>> {
    private final Matcher<T> matcher;

    PresentOptional(Matcher<T> matcher) {
        this.matcher = matcher;
    }

    protected boolean matchesSafely(Optional<? extends T> item, Description mismatchDescription) {
        if (item.isPresent()) {
            if (this.matcher.matches(item.get())) {
                return true;
            }
            mismatchDescription.appendText("was an Optional whose value ");
            this.matcher.describeMismatch(item.get(), mismatchDescription);
            return false;
        }
        mismatchDescription.appendText("was not present");
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("an Optional with a value that ").appendDescriptionOf(this.matcher);
    }
}

