/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.dns;

import com.google.common.collect.ImmutableList;
import com.spotify.dns.DnsException;
import com.spotify.dns.DnsSrvResolver;
import com.spotify.dns.LookupFactory;
import com.spotify.dns.LookupResult;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.SRVRecord;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.lookup.LookupSession;
import org.xbill.DNS.lookup.NoSuchDomainException;
import org.xbill.DNS.lookup.NoSuchRRSetException;

class XBillDnsSrvResolver
implements DnsSrvResolver {
    private static final Logger LOG = LoggerFactory.getLogger(XBillDnsSrvResolver.class);
    private final LookupFactory lookupFactory;

    XBillDnsSrvResolver(LookupFactory lookupFactory) {
        this.lookupFactory = Objects.requireNonNull(lookupFactory, "lookupFactory");
    }

    @Override
    public List<LookupResult> resolve(String fqdn) {
        Lookup lookup = this.lookupFactory.forName(fqdn);
        Record[] queryResult = lookup.run();
        switch (lookup.getResult()) {
            case 0: {
                return XBillDnsSrvResolver.toLookupResults(queryResult);
            }
            case 3: 
            case 4: {
                LOG.warn("No results returned for query '{}'; result from XBill: {} - {}", new Object[]{fqdn, lookup.getResult(), lookup.getErrorString()});
                return ImmutableList.of();
            }
        }
        throw new DnsException(String.format("Lookup of '%s' failed with code: %d - %s ", fqdn, lookup.getResult(), lookup.getErrorString()));
    }

    @Override
    public CompletionStage<List<LookupResult>> resolveAsync(String fqdn) {
        Name name;
        LookupSession lookup = this.lookupFactory.sessionForName(fqdn);
        try {
            name = Name.fromString((String)fqdn);
        }
        catch (TextParseException e) {
            throw new DnsException("unable to create lookup for name: " + fqdn, e);
        }
        return lookup.lookupAsync(name, 33, 1).handle((result, ex) -> {
            if (ex == null) {
                return XBillDnsSrvResolver.toLookupResults(result);
            }
            Throwable cause = ex;
            if (ex instanceof CompletionException && ex.getCause() != null) {
                cause = ex.getCause();
            }
            if (cause instanceof NoSuchRRSetException || cause instanceof NoSuchDomainException) {
                LOG.warn("No results returned for query '{}'; result from dnsjava: {}", (Object)fqdn, (Object)ex.getMessage());
                return ImmutableList.of();
            }
            throw new DnsException(String.format("Lookup of '%s' failed: %s ", fqdn, ex.getMessage()), (Throwable)ex);
        });
    }

    private static List<LookupResult> toLookupResults(org.xbill.DNS.lookup.LookupResult queryResult) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Record record : queryResult.getRecords()) {
            if (!(record instanceof SRVRecord)) continue;
            SRVRecord srvRecord = (SRVRecord)record;
            builder.add((Object)LookupResult.create(srvRecord.getTarget().toString(), srvRecord.getPort(), srvRecord.getPriority(), srvRecord.getWeight(), srvRecord.getTTL()));
        }
        return builder.build();
    }

    private static List<LookupResult> toLookupResults(Record[] queryResult) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (queryResult != null) {
            for (Record record : queryResult) {
                if (!(record instanceof SRVRecord)) continue;
                SRVRecord srvRecord = (SRVRecord)record;
                builder.add((Object)LookupResult.create(srvRecord.getTarget().toString(), srvRecord.getPort(), srvRecord.getPriority(), srvRecord.getWeight(), srvRecord.getTTL()));
            }
        }
        return builder.build();
    }
}

