/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.dns;

import com.spotify.dns.CachingLookupFactory;
import com.spotify.dns.DnsSrvResolver;
import com.spotify.dns.LookupFactory;
import com.spotify.dns.MeteredDnsSrvResolver;
import com.spotify.dns.RetainingDnsSrvResolver;
import com.spotify.dns.SimpleLookupFactory;
import com.spotify.dns.XBillDnsSrvResolver;
import com.spotify.dns.statistics.DnsReporter;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Resolver;

public final class DnsSrvResolvers {
    private static final int DEFAULT_DNS_TIMEOUT_SECONDS = 5;
    private static final int DEFAULT_RETENTION_DURATION_HOURS = 2;

    public static DnsSrvResolverBuilder newBuilder() {
        return new DnsSrvResolverBuilder();
    }

    private DnsSrvResolvers() {
    }

    public static final class DnsSrvResolverBuilder {
        private final DnsReporter reporter;
        private final boolean retainData;
        private final boolean cacheLookups;
        private final long dnsLookupTimeoutMillis;
        private final long retentionDurationMillis;
        private final List<String> servers;
        private final Executor executor;

        private DnsSrvResolverBuilder() {
            this(null, false, false, TimeUnit.SECONDS.toMillis(5L), TimeUnit.HOURS.toMillis(2L), null, null);
        }

        private DnsSrvResolverBuilder(DnsReporter reporter, boolean retainData, boolean cacheLookups, long dnsLookupTimeoutMillis, long retentionDurationMillis, List<String> servers, Executor executor) {
            this.reporter = reporter;
            this.retainData = retainData;
            this.cacheLookups = cacheLookups;
            this.dnsLookupTimeoutMillis = dnsLookupTimeoutMillis;
            this.retentionDurationMillis = retentionDurationMillis;
            this.servers = servers;
            this.executor = executor;
        }

        public DnsSrvResolver build() {
            LookupFactory lookupFactory;
            ExtendedResolver resolver;
            try {
                resolver = this.servers == null ? new ExtendedResolver() : new ExtendedResolver(this.servers.toArray(new String[0]));
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
            Duration timeoutDuration = Duration.ofMillis(this.dnsLookupTimeoutMillis);
            resolver.setTimeout(timeoutDuration);
            SimpleLookupFactory simpleLookupFactory = lookupFactory = this.executor == null ? new SimpleLookupFactory((Resolver)resolver, ForkJoinPool.commonPool()) : new SimpleLookupFactory((Resolver)resolver, this.executor);
            if (this.cacheLookups) {
                lookupFactory = new CachingLookupFactory(lookupFactory);
            }
            DnsSrvResolver result = new XBillDnsSrvResolver(lookupFactory);
            if (this.reporter != null) {
                result = new MeteredDnsSrvResolver(result, this.reporter);
            }
            if (this.retainData) {
                result = new RetainingDnsSrvResolver(result, this.retentionDurationMillis);
            }
            return result;
        }

        public DnsSrvResolverBuilder metered(DnsReporter reporter) {
            return new DnsSrvResolverBuilder(reporter, this.retainData, this.cacheLookups, this.dnsLookupTimeoutMillis, this.retentionDurationMillis, this.servers, this.executor);
        }

        public DnsSrvResolverBuilder retainingDataOnFailures(boolean retainData) {
            return new DnsSrvResolverBuilder(this.reporter, retainData, this.cacheLookups, this.dnsLookupTimeoutMillis, this.retentionDurationMillis, this.servers, this.executor);
        }

        @Deprecated
        public DnsSrvResolverBuilder cachingLookups(boolean cacheLookups) {
            return new DnsSrvResolverBuilder(this.reporter, this.retainData, cacheLookups, this.dnsLookupTimeoutMillis, this.retentionDurationMillis, this.servers, this.executor);
        }

        public DnsSrvResolverBuilder dnsLookupTimeoutMillis(long dnsLookupTimeoutMillis) {
            return new DnsSrvResolverBuilder(this.reporter, this.retainData, this.cacheLookups, dnsLookupTimeoutMillis, this.retentionDurationMillis, this.servers, this.executor);
        }

        public DnsSrvResolverBuilder retentionDurationMillis(long retentionDurationMillis) {
            return new DnsSrvResolverBuilder(this.reporter, this.retainData, this.cacheLookups, this.dnsLookupTimeoutMillis, retentionDurationMillis, this.servers, this.executor);
        }

        public DnsSrvResolverBuilder executor(Executor executor) {
            return new DnsSrvResolverBuilder(this.reporter, this.retainData, this.cacheLookups, this.dnsLookupTimeoutMillis, this.retentionDurationMillis, this.servers, executor);
        }

        public DnsSrvResolverBuilder servers(List<String> servers) {
            return new DnsSrvResolverBuilder(this.reporter, this.retainData, this.cacheLookups, this.dnsLookupTimeoutMillis, this.retentionDurationMillis, servers, this.executor);
        }
    }
}

