/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.dns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.spotify.dns.AbstractChangeNotifier;
import com.spotify.dns.ChangeNotifier;
import com.spotify.dns.ChangeNotifiers;
import java.util.List;
import java.util.Set;

class AggregatingChangeNotifier<T>
extends AbstractChangeNotifier<T> {
    private final List<ChangeNotifier<T>> changeNotifiers;
    private volatile Set<T> records;

    AggregatingChangeNotifier(Iterable<ChangeNotifier<T>> changeNotifiers) {
        this.changeNotifiers = ImmutableList.copyOf(changeNotifiers);
        for (ChangeNotifier changeNotifier : this.changeNotifiers) {
            changeNotifier.setListener(ignored -> this.checkChange(), false);
        }
        this.records = this.aggregateSet();
    }

    @Override
    public Set<T> current() {
        return this.records;
    }

    @Override
    protected void closeImplementation() {
        for (ChangeNotifier<T> provider : this.changeNotifiers) {
            provider.close();
        }
    }

    private synchronized void checkChange() {
        Set<T> currentRecords = this.aggregateSet();
        if (ChangeNotifiers.isNoLongerInitial(currentRecords, this.records) || !currentRecords.equals(this.records)) {
            ChangeNotifier.ChangeNotification<T> changeNotification = this.newChangeNotification(currentRecords, this.records);
            this.records = currentRecords;
            this.fireRecordsUpdated(changeNotification);
        }
    }

    private Set<T> aggregateSet() {
        if (this.areAllInitial(this.changeNotifiers)) {
            return ChangeNotifiers.initialEmptyDataInstance();
        }
        ImmutableSet.Builder records = ImmutableSet.builder();
        for (ChangeNotifier<T> changeNotifier : this.changeNotifiers) {
            records.addAll(changeNotifier.current());
        }
        return records.build();
    }

    private boolean areAllInitial(List<ChangeNotifier<T>> changeNotifiers) {
        for (ChangeNotifier<T> changeNotifier : changeNotifiers) {
            if (ChangeNotifiers.isInitialEmptyData(changeNotifier.current())) continue;
            return false;
        }
        return true;
    }
}

