/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.dns;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.spotify.dns.DnsSrvResolver;
import com.spotify.dns.LookupResult;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

class RetainingDnsSrvResolver
implements DnsSrvResolver {
    private final DnsSrvResolver delegate;
    private final Cache<String, List<LookupResult>> cache;

    RetainingDnsSrvResolver(DnsSrvResolver delegate, long retentionTimeMillis) {
        Preconditions.checkArgument((retentionTimeMillis > 0L ? 1 : 0) != 0, (String)"retention time must be positive, was %d", (long)retentionTimeMillis);
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(retentionTimeMillis, TimeUnit.MILLISECONDS).build();
    }

    @Override
    public List<LookupResult> resolve(String fqdn) {
        Objects.requireNonNull(fqdn, "fqdn");
        try {
            List<LookupResult> nodes = this.delegate.resolve(fqdn);
            if (nodes.isEmpty()) {
                List<LookupResult> cached = (List<LookupResult>)this.cache.getIfPresent((Object)fqdn);
                return cached != null ? cached : nodes;
            }
            this.cache.put((Object)fqdn, nodes);
            return nodes;
        }
        catch (Exception e) {
            if (this.cache.getIfPresent((Object)fqdn) != null) {
                return (List)this.cache.getIfPresent((Object)fqdn);
            }
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

