/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.dns;

import com.spotify.dns.ChangeNotifier;
import com.spotify.dns.ChangeNotifierFactory;
import com.spotify.dns.DnsSrvWatcher;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

class PollingDnsSrvWatcher<T>
implements DnsSrvWatcher<T> {
    private final ChangeNotifierFactory<T> changeNotifierFactory;
    private final ScheduledExecutorService executor;
    private final long pollingInterval;
    private final TimeUnit pollingIntervalUnit;

    PollingDnsSrvWatcher(ChangeNotifierFactory<T> changeNotifierFactory, ScheduledExecutorService executor, long pollingInterval, TimeUnit pollingIntervalUnit) {
        this.changeNotifierFactory = Objects.requireNonNull(changeNotifierFactory, "changeNotifierFactory");
        this.executor = Objects.requireNonNull(executor, "executor");
        this.pollingInterval = pollingInterval;
        this.pollingIntervalUnit = Objects.requireNonNull(pollingIntervalUnit, "pollingIntervalUnit");
    }

    @Override
    public ChangeNotifier<T> watch(String fqdn) {
        ChangeNotifierFactory.RunnableChangeNotifier<T> changeNotifier = this.changeNotifierFactory.create(fqdn);
        ScheduledFuture<?> updaterFuture = this.executor.scheduleWithFixedDelay(changeNotifier, 0L, this.pollingInterval, this.pollingIntervalUnit);
        return changeNotifier;
    }

    @Override
    public void close() throws IOException {
        this.executor.shutdownNow();
    }
}

