/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.dns;

import com.google.common.base.Preconditions;

public class LookupResult {
    private final String host;
    private final int port;
    private final int priority;
    private final int weight;
    private final long ttl;

    private LookupResult(String host, int port, int priority, int weight, long ttl) {
        this.host = (String)Preconditions.checkNotNull((Object)host, (Object)"host");
        this.port = port;
        this.priority = priority;
        this.weight = weight;
        this.ttl = ttl;
    }

    public static LookupResult create(String host, int port, int priority, int weight, long ttl) {
        return new LookupResult(host, port, priority, weight, ttl);
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public int priority() {
        return this.priority;
    }

    public int weight() {
        return this.weight;
    }

    public long ttl() {
        return this.ttl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LookupResult that = (LookupResult)o;
        if (this.port != that.port) {
            return false;
        }
        if (this.priority != that.priority) {
            return false;
        }
        if (this.weight != that.weight) {
            return false;
        }
        if (this.ttl != that.ttl) {
            return false;
        }
        return !(this.host == null ? that.host != null : !this.host.equals(that.host));
    }

    public int hashCode() {
        int result = this.host != null ? this.host.hashCode() : 0;
        result = 31 * result + this.port;
        result = 31 * result + this.priority;
        result = 31 * result + this.weight;
        result = 31 * result + (int)(this.ttl ^ this.ttl >>> 32);
        return result;
    }

    public String toString() {
        return "LookupResult{host='" + this.host + '\'' + ", port=" + this.port + ", priority=" + this.priority + ", weight=" + this.weight + ", ttl=" + this.ttl + '}';
    }
}

