/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.sdk.android.auth;

import androidx.annotation.NonNull;
import com.spotify.sdk.android.auth.TokenExchangeResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;

public class TokenExchangeRequest {
    private static final String TOKEN_ENDPOINT = "https://accounts.spotify.com/api/token";
    private static final String CONTENT_TYPE_FORM = "application/x-www-form-urlencoded";
    private static final String GRANT_TYPE_AUTHORIZATION_CODE = "authorization_code";
    private static final int TIMEOUT_MS = 10000;
    private final String mClientId;
    private final String mCode;
    private final String mRedirectUri;
    private final String mCodeVerifier;

    public TokenExchangeRequest(@NonNull String clientId, @NonNull String code, @NonNull String redirectUri, @NonNull String codeVerifier) {
        if (clientId == null || clientId.isEmpty()) {
            throw new IllegalArgumentException("Client ID cannot be null or empty");
        }
        if (code == null || code.isEmpty()) {
            throw new IllegalArgumentException("Authorization code cannot be null or empty");
        }
        if (redirectUri == null || redirectUri.isEmpty()) {
            throw new IllegalArgumentException("Redirect URI cannot be null or empty");
        }
        if (codeVerifier == null || codeVerifier.isEmpty()) {
            throw new IllegalArgumentException("Code verifier cannot be null or empty");
        }
        this.mClientId = clientId;
        this.mCode = code;
        this.mRedirectUri = redirectUri;
        this.mCodeVerifier = codeVerifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public TokenExchangeResponse execute() {
        HttpURLConnection connection = null;
        try {
            URL url = new URL(TOKEN_ENDPOINT);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", CONTENT_TYPE_FORM);
            connection.setDoOutput(true);
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            String requestBody = this.buildRequestBody();
            try (OutputStream outputStream = connection.getOutputStream();){
                try {
                    outputStream.write(requestBody.getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("UTF-8 encoding not supported", e);
                }
                outputStream.flush();
            }
            int responseCode = connection.getResponseCode();
            String responseBody = this.readResponse(connection, responseCode >= 400);
            TokenExchangeResponse tokenExchangeResponse = TokenExchangeResponse.fromHttpResponse(responseCode, responseBody);
            return tokenExchangeResponse;
        }
        catch (IOException e) {
            TokenExchangeResponse tokenExchangeResponse = TokenExchangeResponse.fromError("network_error", "Network error: " + e.getMessage());
            return tokenExchangeResponse;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    @NonNull
    private String buildRequestBody() {
        try {
            return "grant_type=" + URLEncoder.encode(GRANT_TYPE_AUTHORIZATION_CODE, "UTF-8") + "&client_id=" + URLEncoder.encode(this.mClientId, "UTF-8") + "&code=" + URLEncoder.encode(this.mCode, "UTF-8") + "&redirect_uri=" + URLEncoder.encode(this.mRedirectUri, "UTF-8") + "&code_verifier=" + URLEncoder.encode(this.mCodeVerifier, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to encode request parameters", e);
        }
    }

    @NonNull
    private String readResponse(@NonNull HttpURLConnection connection, boolean isError) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(isError ? connection.getErrorStream() : connection.getInputStream(), "UTF-8"));){
            String line;
            StringBuilder response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            String string = response.toString();
            return string;
        }
    }

    public static class Builder {
        private String mClientId;
        private String mCode;
        private String mRedirectUri;
        private String mCodeVerifier;

        @NonNull
        public Builder setClientId(@NonNull String clientId) {
            this.mClientId = clientId;
            return this;
        }

        @NonNull
        public Builder setCode(@NonNull String code) {
            this.mCode = code;
            return this;
        }

        @NonNull
        public Builder setRedirectUri(@NonNull String redirectUri) {
            this.mRedirectUri = redirectUri;
            return this;
        }

        @NonNull
        public Builder setCodeVerifier(@NonNull String codeVerifier) {
            this.mCodeVerifier = codeVerifier;
            return this;
        }

        @NonNull
        public TokenExchangeRequest build() {
            return new TokenExchangeRequest(this.mClientId, this.mCode, this.mRedirectUri, this.mCodeVerifier);
        }
    }
}

