/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.sdk.android.auth;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import com.spotify.sdk.android.auth.AuthorizationHandler;
import com.spotify.sdk.android.auth.AuthorizationRequest;
import com.spotify.sdk.android.auth.AuthorizationResponse;
import com.spotify.sdk.android.auth.FallbackHandlerProvider;
import com.spotify.sdk.android.auth.LoginActivity;
import com.spotify.sdk.android.auth.app.SpotifyAuthHandler;
import java.util.ArrayList;
import java.util.List;

public class AuthorizationClient {
    private static final String TAG = "Spotify Auth Client";
    static final String MARKET_VIEW_PATH = "market://";
    static final String MARKET_SCHEME = "market";
    static final String MARKET_PATH = "details";
    static final String PLAY_STORE_SCHEME = "https";
    static final String PLAY_STORE_AUTHORITY = "play.google.com";
    static final String PLAY_STORE_PATH = "store/apps/details";
    static final String SPOTIFY_ID = "com.spotify.music";
    static final String SPOTIFY_SDK = "spotify-sdk";
    static final String ANDROID_SDK = "android-sdk";
    static final String DEFAULT_CAMPAIGN = "android-sdk";
    private final Activity mLoginActivity;
    private boolean mAuthorizationPending;
    private AuthorizationHandler mCurrentHandler;
    private List<AuthorizationHandler> mAuthorizationHandlers = new ArrayList<AuthorizationHandler>();
    private AuthorizationClientListener mAuthorizationClientListener;

    public static void openLoginInBrowser(Activity contextActivity, AuthorizationRequest request) {
        Intent launchBrowser = new Intent("android.intent.action.VIEW", request.toUri());
        contextActivity.startActivity(launchBrowser);
    }

    public static Intent createLoginActivityIntent(Activity contextActivity, AuthorizationRequest request) {
        Intent intent = LoginActivity.getAuthIntent(contextActivity, request);
        intent.addFlags(0x4000000);
        return intent;
    }

    public static void openLoginActivity(Activity contextActivity, int requestCode, AuthorizationRequest request) {
        Intent intent = AuthorizationClient.createLoginActivityIntent(contextActivity, request);
        contextActivity.startActivityForResult(intent, requestCode);
    }

    public static void stopLoginActivity(Activity contextActivity, int requestCode) {
        contextActivity.finishActivity(requestCode);
    }

    public static AuthorizationResponse getResponse(int resultCode, Intent intent) {
        if (resultCode == -1 && LoginActivity.getResponseFromIntent(intent) != null) {
            return LoginActivity.getResponseFromIntent(intent);
        }
        return new AuthorizationResponse.Builder().setType(AuthorizationResponse.Type.EMPTY).build();
    }

    public static void openDownloadSpotifyActivity(Activity contextActivity) {
        AuthorizationClient.openDownloadSpotifyActivity(contextActivity, "android-sdk");
    }

    public static void openDownloadSpotifyActivity(Activity contextActivity, String campaign) {
        Uri.Builder uriBuilder = new Uri.Builder();
        if (AuthorizationClient.isAvailable((Context)contextActivity, new Intent("android.intent.action.VIEW", Uri.parse((String)MARKET_VIEW_PATH)))) {
            uriBuilder.scheme(MARKET_SCHEME).appendPath(MARKET_PATH);
        } else {
            uriBuilder.scheme(PLAY_STORE_SCHEME).authority(PLAY_STORE_AUTHORITY).appendEncodedPath(PLAY_STORE_PATH);
        }
        uriBuilder.appendQueryParameter("id", SPOTIFY_ID);
        Uri.Builder referrerBuilder = new Uri.Builder();
        referrerBuilder.appendQueryParameter("utm_source", SPOTIFY_SDK).appendQueryParameter("utm_medium", "android-sdk");
        if (TextUtils.isEmpty((CharSequence)campaign)) {
            referrerBuilder.appendQueryParameter("utm_campaign", "android-sdk");
        } else {
            referrerBuilder.appendQueryParameter("utm_campaign", campaign);
        }
        uriBuilder.appendQueryParameter("referrer", referrerBuilder.build().getEncodedQuery());
        contextActivity.startActivity(new Intent("android.intent.action.VIEW", uriBuilder.build()));
    }

    public static boolean isAvailable(Context ctx, Intent intent) {
        PackageManager mgr = ctx.getPackageManager();
        List list = mgr.queryIntentActivities(intent, 65536);
        return list.size() > 0;
    }

    public AuthorizationClient(Activity activity) {
        this.mLoginActivity = activity;
        this.mAuthorizationHandlers.add(new SpotifyAuthHandler());
        this.mAuthorizationHandlers.add(new FallbackHandlerProvider().provideFallback());
    }

    void setOnCompleteListener(AuthorizationClientListener listener) {
        this.mAuthorizationClientListener = listener;
    }

    void authorize(AuthorizationRequest request) {
        if (this.mAuthorizationPending) {
            return;
        }
        this.mAuthorizationPending = true;
        for (AuthorizationHandler authHandler : this.mAuthorizationHandlers) {
            if (!this.tryAuthorizationHandler(authHandler, request)) continue;
            this.mCurrentHandler = authHandler;
            break;
        }
    }

    void cancel() {
        if (!this.mAuthorizationPending) {
            return;
        }
        this.mAuthorizationPending = false;
        this.closeAuthorizationHandler(this.mCurrentHandler);
        if (this.mAuthorizationClientListener != null) {
            this.mAuthorizationClientListener.onClientCancelled();
            this.mAuthorizationClientListener = null;
        }
    }

    void complete(AuthorizationResponse response) {
        this.sendComplete(this.mCurrentHandler, response);
    }

    private void sendComplete(AuthorizationHandler authHandler, AuthorizationResponse response) {
        this.mAuthorizationPending = false;
        this.closeAuthorizationHandler(authHandler);
        if (this.mAuthorizationClientListener != null) {
            this.mAuthorizationClientListener.onClientComplete(response);
            this.mAuthorizationClientListener = null;
        } else {
            Log.w((String)TAG, (String)"Can't deliver the Spotify Auth response. The listener is null");
        }
    }

    private boolean tryAuthorizationHandler(final AuthorizationHandler authHandler, AuthorizationRequest request) {
        authHandler.setOnCompleteListener(new AuthorizationHandler.OnCompleteListener(){

            @Override
            public void onComplete(AuthorizationResponse response) {
                Log.i((String)AuthorizationClient.TAG, (String)String.format("Spotify auth response:%s", response.getType().name()));
                AuthorizationClient.this.sendComplete(authHandler, response);
            }

            @Override
            public void onCancel() {
                Log.i((String)AuthorizationClient.TAG, (String)"Spotify auth response: User cancelled");
                AuthorizationResponse response = new AuthorizationResponse.Builder().setType(AuthorizationResponse.Type.EMPTY).build();
                AuthorizationClient.this.sendComplete(authHandler, response);
            }

            @Override
            public void onError(Throwable error) {
                Log.e((String)AuthorizationClient.TAG, (String)"Spotify auth Error", (Throwable)error);
                AuthorizationResponse response = new AuthorizationResponse.Builder().setType(AuthorizationResponse.Type.ERROR).setError(error.getMessage()).build();
                AuthorizationClient.this.sendComplete(authHandler, response);
            }
        });
        if (!authHandler.start(this.mLoginActivity, request)) {
            this.closeAuthorizationHandler(authHandler);
            return false;
        }
        return true;
    }

    private void closeAuthorizationHandler(AuthorizationHandler authHandler) {
        if (authHandler != null) {
            authHandler.setOnCompleteListener(null);
            authHandler.stop();
        }
    }

    static interface AuthorizationClientListener {
        public void onClientComplete(AuthorizationResponse var1);

        public void onClientCancelled();
    }

    static final class PlayStoreParams {
        public static final String ID = "id";
        public static final String REFERRER = "referrer";
        public static final String UTM_SOURCE = "utm_source";
        public static final String UTM_MEDIUM = "utm_medium";
        public static final String UTM_CAMPAIGN = "utm_campaign";

        PlayStoreParams() {
        }
    }
}

