/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.sdk.android.auth.webview;

import android.content.Context;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;

class WebViewUtils {
    WebViewUtils() {
    }

    static void clearFacebookCookies(Context context) {
        WebViewUtils.clearCookiesForDomain(context, "facebook.com");
        WebViewUtils.clearCookiesForDomain(context, ".facebook.com");
        WebViewUtils.clearCookiesForDomain(context, "https://facebook.com");
        WebViewUtils.clearCookiesForDomain(context, "https://.facebook.com");
    }

    static void clearCookiesForDomain(Context context, String domain) {
        String[] splitCookies;
        CookieSyncManager syncManager = CookieSyncManager.createInstance((Context)context);
        syncManager.sync();
        CookieManager cookieManager = CookieManager.getInstance();
        String cookies = cookieManager.getCookie(domain);
        if (cookies == null) {
            return;
        }
        for (String cookie : splitCookies = cookies.split(";")) {
            String[] cookieParts = cookie.split("=");
            if (cookieParts.length <= 0) continue;
            String newCookie = cookieParts[0].trim() + "=;expires=Sat, 1 Jan 2000 00:00:01 UTC;";
            cookieManager.setCookie(domain, newCookie);
        }
        cookieManager.removeExpiredCookie();
    }
}

