/*
 * Decompiled with CFR 0.152.
 */
package com.tokenautocomplete;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.tokenautocomplete.Range;
import com.tokenautocomplete.Tokenizer;
import java.util.ArrayList;
import java.util.List;

public class CharacterTokenizer
implements Tokenizer {
    private ArrayList<Character> splitChar;
    private String tokenTerminator;
    public static final Parcelable.Creator<CharacterTokenizer> CREATOR = new Parcelable.Creator<CharacterTokenizer>(){

        public CharacterTokenizer createFromParcel(Parcel in) {
            return new CharacterTokenizer(in);
        }

        public CharacterTokenizer[] newArray(int size) {
            return new CharacterTokenizer[size];
        }
    };

    public CharacterTokenizer(List<Character> splitChar, String tokenTerminator) {
        this.splitChar = new ArrayList<Character>(splitChar);
        this.tokenTerminator = tokenTerminator;
    }

    @Override
    public boolean containsTokenTerminator(CharSequence charSequence) {
        for (int i = 0; i < charSequence.length(); ++i) {
            if (!this.splitChar.contains(Character.valueOf(charSequence.charAt(i)))) continue;
            return true;
        }
        return false;
    }

    @Override
    @NonNull
    public List<Range> findTokenRanges(CharSequence charSequence, int start, int end) {
        ArrayList<Range> result = new ArrayList<Range>();
        if (start == end) {
            return result;
        }
        int tokenStart = start;
        for (int cursor = start; cursor < end; ++cursor) {
            boolean hasTokenContent;
            char character = charSequence.charAt(cursor);
            if (tokenStart == cursor && Character.isWhitespace(character)) {
                tokenStart = cursor + 1;
            }
            if (!this.splitChar.contains(Character.valueOf(character)) && cursor != end - 1) continue;
            boolean bl = hasTokenContent = cursor > tokenStart || cursor == tokenStart && !this.splitChar.contains(Character.valueOf(character));
            if (hasTokenContent) {
                result.add(new Range(tokenStart, cursor + 1));
            }
            tokenStart = cursor + 1;
        }
        return result;
    }

    @Override
    @NonNull
    public CharSequence wrapTokenValue(CharSequence text) {
        String wrappedText = text + this.tokenTerminator;
        if (text instanceof Spanned) {
            SpannableString sp = new SpannableString((CharSequence)wrappedText);
            TextUtils.copySpansFrom((Spanned)((Spanned)text), (int)0, (int)text.length(), Object.class, (Spannable)sp, (int)0);
            return sp;
        }
        return wrappedText;
    }

    public int describeContents() {
        return 0;
    }

    CharacterTokenizer(Parcel in) {
        this(in.readArrayList(Character.class.getClassLoader()), in.readString());
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeList(this.splitChar);
        parcel.writeString(this.tokenTerminator);
    }
}

