/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.compute.internal.expression;

import com.speedment.runtime.compute.ToBigDecimal;
import com.speedment.runtime.compute.ToBoolean;
import com.speedment.runtime.compute.ToByte;
import com.speedment.runtime.compute.ToChar;
import com.speedment.runtime.compute.ToDouble;
import com.speedment.runtime.compute.ToFloat;
import com.speedment.runtime.compute.ToInt;
import com.speedment.runtime.compute.ToLong;
import com.speedment.runtime.compute.ToShort;
import com.speedment.runtime.compute.expression.Expression;
import com.speedment.runtime.compute.expression.UnaryExpression;
import java.math.BigDecimal;
import java.util.Objects;

public final class CastUtil {
    private CastUtil() {
    }

    public static <T> ToDouble<T> castByteToDouble(ToByte<T> original) {
        class ByteToDouble
        extends CastToDouble<T, ToByte<T>> {
            ByteToDouble(ToByte<T> tToByte) {
                super(tToByte);
            }

            @Override
            public double applyAsDouble(T object) {
                return ((ToByte)this.inner).applyAsByte(object);
            }
        }
        return new ByteToDouble(original);
    }

    public static <T> ToDouble<T> castShortToDouble(ToShort<T> original) {
        class ShortToDouble
        extends CastToDouble<T, ToShort<T>> {
            ShortToDouble(ToShort<T> tToShort) {
                super(tToShort);
            }

            @Override
            public double applyAsDouble(T object) {
                return ((ToShort)this.inner).applyAsShort(object);
            }
        }
        return new ShortToDouble(original);
    }

    public static <T> ToDouble<T> castIntToDouble(ToInt<T> original) {
        class IntToDouble
        extends CastToDouble<T, ToInt<T>> {
            IntToDouble(ToInt<T> tToInt) {
                super(tToInt);
            }

            @Override
            public double applyAsDouble(T object) {
                return ((ToInt)this.inner).applyAsInt(object);
            }
        }
        return new IntToDouble(original);
    }

    public static <T> ToDouble<T> castLongToDouble(ToLong<T> original) {
        class LongToDouble
        extends CastToDouble<T, ToLong<T>> {
            LongToDouble(ToLong<T> tToLong) {
                super(tToLong);
            }

            @Override
            public double applyAsDouble(T object) {
                return ((ToLong)this.inner).applyAsLong(object);
            }
        }
        return new LongToDouble(original);
    }

    public static <T> ToDouble<T> castFloatToDouble(ToFloat<T> original) {
        class FloatToDouble
        extends CastToDouble<T, ToFloat<T>> {
            FloatToDouble(ToFloat<T> tToFloat) {
                super(tToFloat);
            }

            @Override
            public double applyAsDouble(T object) {
                return ((ToFloat)this.inner).applyAsFloat(object);
            }
        }
        return new FloatToDouble(original);
    }

    public static <T> ToDouble<T> castBigDecimalToDouble(ToBigDecimal<T> original) {
        class BigDecimalToDouble
        extends CastToDouble<T, ToBigDecimal<T>> {
            BigDecimalToDouble(ToBigDecimal<T> tToBigDecimal) {
                super(tToBigDecimal);
            }

            @Override
            public double applyAsDouble(T object) {
                return ((BigDecimal)((ToBigDecimal)this.inner).apply(object)).doubleValue();
            }
        }
        return new BigDecimalToDouble(original);
    }

    public static <T> ToDouble<T> castBooleanToDouble(ToBoolean<T> original) {
        class BooleanToDouble
        extends CastToDouble<T, ToBoolean<T>> {
            BooleanToDouble(ToBoolean<T> tToBoolean) {
                super(tToBoolean);
            }

            @Override
            public double applyAsDouble(T object) {
                return ((ToBoolean)this.inner).applyAsBoolean(object) ? 1.0 : 0.0;
            }
        }
        return new BooleanToDouble(original);
    }

    public static <T> ToDouble<T> castCharToDouble(ToChar<T> original) {
        class CharToDouble
        extends CastToDouble<T, ToChar<T>> {
            CharToDouble(ToChar<T> tToChar) {
                super(tToChar);
            }

            @Override
            public double applyAsDouble(T object) {
                return ((ToChar)this.inner).applyAsChar(object);
            }
        }
        return new CharToDouble(original);
    }

    public static <T> ToInt<T> castByteToInt(ToByte<T> original) {
        class ByteToInt
        extends CastToInt<T, ToByte<T>> {
            ByteToInt(ToByte<T> tToByte) {
                super(tToByte);
            }

            @Override
            public int applyAsInt(T object) {
                return ((ToByte)this.inner).applyAsByte(object);
            }
        }
        return new ByteToInt(original);
    }

    public static <T> ToInt<T> castShortToInt(ToShort<T> original) {
        class ShortToInt
        extends CastToInt<T, ToShort<T>> {
            ShortToInt(ToShort<T> tToShort) {
                super(tToShort);
            }

            @Override
            public int applyAsInt(T object) {
                return ((ToShort)this.inner).applyAsShort(object);
            }
        }
        return new ShortToInt(original);
    }

    public static <T> ToInt<T> castLongToInt(ToLong<T> original) {
        class LongToInt
        extends CastToInt<T, ToLong<T>> {
            LongToInt(ToLong<T> tToLong) {
                super(tToLong);
            }

            @Override
            public int applyAsInt(T object) {
                return (int)((ToLong)this.inner).applyAsLong(object);
            }
        }
        return new LongToInt(original);
    }

    public static <T> ToInt<T> castFloatToInt(ToFloat<T> original) {
        class FloatToInt
        extends CastToInt<T, ToFloat<T>> {
            FloatToInt(ToFloat<T> tToFloat) {
                super(tToFloat);
            }

            @Override
            public int applyAsInt(T object) {
                return (int)((ToFloat)this.inner).applyAsFloat(object);
            }
        }
        return new FloatToInt(original);
    }

    public static <T> ToInt<T> castDoubleToInt(ToDouble<T> original) {
        class DoubleToInt
        extends CastToInt<T, ToDouble<T>> {
            DoubleToInt(ToDouble<T> tToDouble) {
                super(tToDouble);
            }

            @Override
            public int applyAsInt(T object) {
                return (int)((ToDouble)this.inner).applyAsDouble(object);
            }
        }
        return new DoubleToInt(original);
    }

    public static <T> ToInt<T> castBigDecimalToInt(ToBigDecimal<T> original) {
        class BigDecimalToInt
        extends CastToInt<T, ToBigDecimal<T>> {
            BigDecimalToInt(ToBigDecimal<T> tToBigDecimal) {
                super(tToBigDecimal);
            }

            @Override
            public int applyAsInt(T object) {
                return ((BigDecimal)((ToBigDecimal)this.inner).apply(object)).intValueExact();
            }
        }
        return new BigDecimalToInt(original);
    }

    public static <T> ToInt<T> castBooleanToInt(ToBoolean<T> original) {
        class BooleanToInt
        extends CastToInt<T, ToBoolean<T>> {
            BooleanToInt(ToBoolean<T> tToBoolean) {
                super(tToBoolean);
            }

            @Override
            public int applyAsInt(T object) {
                return ((ToBoolean)this.inner).applyAsBoolean(object) ? 1 : 0;
            }
        }
        return new BooleanToInt(original);
    }

    public static <T> ToInt<T> castCharToInt(ToChar<T> original) {
        class CharToInt
        extends CastToInt<T, ToChar<T>> {
            CharToInt(ToChar<T> tToChar) {
                super(tToChar);
            }

            @Override
            public int applyAsInt(T object) {
                return ((ToChar)this.inner).applyAsChar(object);
            }
        }
        return new CharToInt(original);
    }

    public static <T> ToLong<T> castByteToLong(ToByte<T> original) {
        class ByteToLong
        extends CastToLong<T, ToByte<T>> {
            ByteToLong(ToByte<T> tToByte) {
                super(tToByte);
            }

            @Override
            public long applyAsLong(T object) {
                return ((ToByte)this.inner).applyAsByte(object);
            }
        }
        return new ByteToLong(original);
    }

    public static <T> ToLong<T> castShortToLong(ToShort<T> original) {
        class ShortToLong
        extends CastToLong<T, ToShort<T>> {
            ShortToLong(ToShort<T> tToShort) {
                super(tToShort);
            }

            @Override
            public long applyAsLong(T object) {
                return ((ToShort)this.inner).applyAsShort(object);
            }
        }
        return new ShortToLong(original);
    }

    public static <T> ToLong<T> castIntToLong(ToInt<T> original) {
        class IntToLong
        extends CastToLong<T, ToInt<T>> {
            IntToLong(ToInt<T> tToInt) {
                super(tToInt);
            }

            @Override
            public long applyAsLong(T object) {
                return ((ToInt)this.inner).applyAsInt(object);
            }
        }
        return new IntToLong(original);
    }

    public static <T> ToLong<T> castFloatToLong(ToFloat<T> original) {
        class FloatToLong
        extends CastToLong<T, ToFloat<T>> {
            FloatToLong(ToFloat<T> tToFloat) {
                super(tToFloat);
            }

            @Override
            public long applyAsLong(T object) {
                return (long)((ToFloat)this.inner).applyAsFloat(object);
            }
        }
        return new FloatToLong(original);
    }

    public static <T> ToLong<T> castDoubleToLong(ToDouble<T> original) {
        class DoubleToLong
        extends CastToLong<T, ToDouble<T>> {
            DoubleToLong(ToDouble<T> tToDouble) {
                super(tToDouble);
            }

            @Override
            public long applyAsLong(T object) {
                return (long)((ToDouble)this.inner).applyAsDouble(object);
            }
        }
        return new DoubleToLong(original);
    }

    public static <T> ToLong<T> castBigDecimalToLong(ToBigDecimal<T> original) {
        class BigDecimalToLong
        extends CastToLong<T, ToBigDecimal<T>> {
            BigDecimalToLong(ToBigDecimal<T> tToBigDecimal) {
                super(tToBigDecimal);
            }

            @Override
            public long applyAsLong(T object) {
                return ((BigDecimal)((ToBigDecimal)this.inner).apply(object)).longValueExact();
            }
        }
        return new BigDecimalToLong(original);
    }

    public static <T> ToLong<T> castBooleanToLong(ToBoolean<T> original) {
        class BooleanToLong
        extends CastToLong<T, ToBoolean<T>> {
            BooleanToLong(ToBoolean<T> tToBoolean) {
                super(tToBoolean);
            }

            @Override
            public long applyAsLong(T object) {
                return ((ToBoolean)this.inner).applyAsBoolean(object) ? 1L : 0L;
            }
        }
        return new BooleanToLong(original);
    }

    public static <T> ToLong<T> castCharToLong(ToChar<T> original) {
        class CharToLong
        extends CastToLong<T, ToChar<T>> {
            CharToLong(ToChar<T> tToChar) {
                super(tToChar);
            }

            @Override
            public long applyAsLong(T object) {
                return ((ToChar)this.inner).applyAsChar(object);
            }
        }
        return new CharToLong(original);
    }

    static abstract class AbstractCast<T, INNER extends Expression<T>>
    implements UnaryExpression<T, INNER> {
        final INNER inner;

        AbstractCast(INNER inner) {
            this.inner = (Expression)Objects.requireNonNull(inner);
        }

        @Override
        public final INNER inner() {
            return this.inner;
        }

        @Override
        public final UnaryExpression.Operator operator() {
            return UnaryExpression.Operator.CAST;
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UnaryExpression)) {
                return false;
            }
            UnaryExpression that = (UnaryExpression)o;
            return Objects.equals(this.inner(), that.inner()) && this.operator() == that.operator();
        }

        public final int hashCode() {
            return Objects.hash(new Object[]{this.inner(), this.operator()});
        }
    }

    private static abstract class CastToLong<T, INNER extends Expression<T>>
    extends AbstractCast<T, INNER>
    implements ToLong<T> {
        CastToLong(INNER inner) {
            super(inner);
        }
    }

    private static abstract class CastToInt<T, INNER extends Expression<T>>
    extends AbstractCast<T, INNER>
    implements ToInt<T> {
        CastToInt(INNER inner) {
            super(inner);
        }
    }

    private static abstract class CastToDouble<T, INNER extends Expression<T>>
    extends AbstractCast<T, INNER>
    implements ToDouble<T> {
        CastToDouble(INNER inner) {
            super(inner);
        }
    }
}

