/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.compute;

import com.speedment.common.function.ShortToDoubleFunction;
import com.speedment.common.function.ShortUnaryOperator;
import com.speedment.common.function.ToShortFunction;
import com.speedment.runtime.compute.ToByte;
import com.speedment.runtime.compute.ToDouble;
import com.speedment.runtime.compute.ToInt;
import com.speedment.runtime.compute.ToLong;
import com.speedment.runtime.compute.ToShortNullable;
import com.speedment.runtime.compute.expression.Expression;
import com.speedment.runtime.compute.expression.ExpressionType;
import com.speedment.runtime.compute.expression.Expressions;
import com.speedment.runtime.compute.internal.expression.CastUtil;
import com.speedment.runtime.compute.internal.expression.ComposedUtil;
import com.speedment.runtime.compute.internal.expression.MapperUtil;
import com.speedment.runtime.compute.trait.HasAbs;
import com.speedment.runtime.compute.trait.HasAsDouble;
import com.speedment.runtime.compute.trait.HasAsInt;
import com.speedment.runtime.compute.trait.HasAsLong;
import com.speedment.runtime.compute.trait.HasCompare;
import com.speedment.runtime.compute.trait.HasCompose;
import com.speedment.runtime.compute.trait.HasDivide;
import com.speedment.runtime.compute.trait.HasHash;
import com.speedment.runtime.compute.trait.HasMap;
import com.speedment.runtime.compute.trait.HasMapToDouble;
import com.speedment.runtime.compute.trait.HasMinus;
import com.speedment.runtime.compute.trait.HasMultiply;
import com.speedment.runtime.compute.trait.HasNegate;
import com.speedment.runtime.compute.trait.HasPlus;
import com.speedment.runtime.compute.trait.HasPow;
import com.speedment.runtime.compute.trait.HasSign;
import com.speedment.runtime.compute.trait.HasSqrt;
import java.util.function.Function;

@FunctionalInterface
public interface ToShort<T>
extends Expression<T>,
ToShortFunction<T>,
HasAsDouble<T>,
HasAsInt<T>,
HasAsLong<T>,
HasAbs<ToShort<T>>,
HasSign<ToByte<T>>,
HasSqrt<ToDouble<T>>,
HasNegate<ToShort<T>>,
HasPow<T>,
HasPlus<T>,
HasMinus<T>,
HasMultiply<T>,
HasDivide<T>,
HasMap<T, ShortUnaryOperator, ToShort<T>>,
HasMapToDouble<T, ShortToDoubleFunction>,
HasHash<T>,
HasCompare<T>,
HasCompose<T> {
    public static <T> ToShort<T> of(ToShortFunction<T> lambda) {
        if (lambda instanceof ToShort) {
            return (ToShort)lambda;
        }
        return arg_0 -> lambda.applyAsShort(arg_0);
    }

    public short applyAsShort(T var1);

    @Override
    default public ExpressionType expressionType() {
        return ExpressionType.SHORT;
    }

    @Override
    default public ToDouble<T> asDouble() {
        return CastUtil.castShortToDouble(this);
    }

    @Override
    default public ToInt<T> asInt() {
        return CastUtil.castShortToInt(this);
    }

    @Override
    default public ToLong<T> asLong() {
        return CastUtil.castShortToLong(this);
    }

    @Override
    default public ToDouble<T> mapToDouble(ShortToDoubleFunction operator) {
        return MapperUtil.mapShortToDouble(this, operator);
    }

    @Override
    default public ToShort<T> map(ShortUnaryOperator operator) {
        return MapperUtil.mapShort(this, operator);
    }

    @Override
    default public ToShort<T> abs() {
        return Expressions.abs(this);
    }

    @Override
    default public ToByte<T> sign() {
        return Expressions.sign(this);
    }

    @Override
    default public ToDouble<T> sqrt() {
        return Expressions.sqrt(this);
    }

    @Override
    default public ToDouble<T> pow(int power) {
        return Expressions.pow(this, power);
    }

    @Override
    default public ToDouble<T> pow(double power) {
        return Expressions.pow(this, power);
    }

    @Override
    default public ToDouble<T> pow(ToInt<T> power) {
        return Expressions.pow(this, power);
    }

    @Override
    default public ToDouble<T> pow(ToDouble<T> power) {
        return Expressions.pow(this, power);
    }

    @Override
    default public ToInt<T> plus(byte other) {
        return Expressions.plus(this, other);
    }

    @Override
    default public ToInt<T> plus(ToByte<T> other) {
        return Expressions.plus(this.asInt(), other);
    }

    @Override
    default public ToInt<T> plus(int other) {
        return Expressions.plus(this.asInt(), other);
    }

    @Override
    default public ToInt<T> plus(ToInt<T> other) {
        return Expressions.plus(this.asInt(), other);
    }

    @Override
    default public ToLong<T> plus(long other) {
        return Expressions.plus(this, other);
    }

    @Override
    default public ToLong<T> plus(ToLong<T> other) {
        return Expressions.plus(this.asLong(), other);
    }

    @Override
    default public ToDouble<T> plus(double other) {
        return Expressions.plus(this.asDouble(), other);
    }

    @Override
    default public ToDouble<T> plus(ToDouble<T> other) {
        return Expressions.plus(this.asDouble(), other);
    }

    @Override
    default public ToInt<T> minus(byte other) {
        return Expressions.minus(this, other);
    }

    @Override
    default public ToInt<T> minus(ToByte<T> other) {
        return Expressions.minus(this.asInt(), other);
    }

    @Override
    default public ToInt<T> minus(int other) {
        return Expressions.minus(this.asInt(), other);
    }

    @Override
    default public ToInt<T> minus(ToInt<T> other) {
        return Expressions.minus(this.asInt(), other);
    }

    @Override
    default public ToLong<T> minus(long other) {
        return Expressions.minus(this, other);
    }

    @Override
    default public ToLong<T> minus(ToLong<T> other) {
        return Expressions.minus(this.asLong(), other);
    }

    @Override
    default public ToDouble<T> minus(double other) {
        return Expressions.minus(this.asDouble(), other);
    }

    @Override
    default public ToDouble<T> minus(ToDouble<T> other) {
        return Expressions.minus(this.asDouble(), other);
    }

    @Override
    default public ToInt<T> multiply(byte other) {
        return Expressions.multiply(this, other);
    }

    @Override
    default public ToInt<T> multiply(ToByte<T> other) {
        return Expressions.multiply(this.asInt(), other);
    }

    @Override
    default public ToInt<T> multiply(int other) {
        return Expressions.multiply(this.asInt(), other);
    }

    @Override
    default public ToInt<T> multiply(ToInt<T> other) {
        return Expressions.multiply(this.asInt(), other);
    }

    @Override
    default public ToLong<T> multiply(long other) {
        return Expressions.multiply(this, other);
    }

    @Override
    default public ToLong<T> multiply(ToLong<T> other) {
        return Expressions.multiply(this.asLong(), other);
    }

    @Override
    default public ToDouble<T> multiply(double other) {
        return Expressions.multiply(this.asDouble(), other);
    }

    @Override
    default public ToDouble<T> multiply(ToDouble<T> other) {
        return Expressions.multiply(this.asDouble(), other);
    }

    @Override
    default public ToDouble<T> divide(int divisor) {
        return Expressions.divide(this, divisor);
    }

    @Override
    default public ToDouble<T> divide(ToInt<T> divisor) {
        return Expressions.divide(this, divisor);
    }

    @Override
    default public ToDouble<T> divide(long divisor) {
        return Expressions.divide(this, divisor);
    }

    @Override
    default public ToDouble<T> divide(ToLong<T> divisor) {
        return Expressions.divide(this, divisor);
    }

    @Override
    default public ToDouble<T> divide(double divisor) {
        return Expressions.divide(this, divisor);
    }

    @Override
    default public ToDouble<T> divide(ToDouble<T> divisor) {
        return Expressions.divide(this, divisor);
    }

    @Override
    default public ToShort<T> negate() {
        return Expressions.negate(this);
    }

    @Override
    default public long hash(T object) {
        return this.applyAsShort(object);
    }

    @Override
    default public int compare(T first, T second) {
        return Short.compare(this.applyAsShort(first), this.applyAsShort(second));
    }

    @Override
    default public <V> ToShortNullable<V> compose(Function<? super V, ? extends T> before) {
        Function<? super V, ? extends T> casted = before;
        return ComposedUtil.composeToShort(casted, this);
    }
}

