/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.interopoptimizer.standard.internal;

import com.speedment.jpastreamer.interopoptimizer.IntermediateOperationOptimizer;
import com.speedment.jpastreamer.interopoptimizer.IntermediateOperationOptimizerFactory;
import com.speedment.jpastreamer.interopoptimizer.standard.internal.strategy.MoveAnonymousLambdaOperations;
import com.speedment.jpastreamer.interopoptimizer.standard.internal.strategy.RemoveOrderAffectingOperations;
import com.speedment.jpastreamer.interopoptimizer.standard.internal.strategy.SquashDistinct;
import com.speedment.jpastreamer.interopoptimizer.standard.internal.strategy.SquashFilter;
import com.speedment.jpastreamer.interopoptimizer.standard.internal.strategy.SquashLimit;
import com.speedment.jpastreamer.interopoptimizer.standard.internal.strategy.SquashSkip;
import com.speedment.jpastreamer.interopoptimizer.standard.internal.strategy.SquashSorted;
import com.speedment.jpastreamer.pipeline.intermediate.IntermediateOperationFactory;
import com.speedment.jpastreamer.rootfactory.RootFactory;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.stream.Stream;

public final class InternalIntermediateOperationOptimizerFactory
implements IntermediateOperationOptimizerFactory {
    private final Map<Priority, List<IntermediateOperationOptimizer>> intermediateOperationOptimizers = new EnumMap<Priority, List<IntermediateOperationOptimizer>>(Priority.class);

    public InternalIntermediateOperationOptimizerFactory() {
        IntermediateOperationFactory intermediateOperationFactory = (IntermediateOperationFactory)RootFactory.getOrThrow(IntermediateOperationFactory.class, ServiceLoader::load);
        this.intermediateOperationOptimizers.put(Priority.HIGHEST, new ArrayList());
        this.intermediateOperationOptimizers.put(Priority.HIGH, new ArrayList());
        this.intermediateOperationOptimizers.put(Priority.NORMAL, new ArrayList());
        this.intermediateOperationOptimizers.put(Priority.LOW, new ArrayList());
        this.intermediateOperationOptimizers.put(Priority.LOWEST, new ArrayList());
        this.registerOptimizer(new RemoveOrderAffectingOperations(), Priority.HIGHEST);
        this.registerOptimizer(new MoveAnonymousLambdaOperations(), Priority.HIGH);
        this.registerOptimizer(new SquashSkip(intermediateOperationFactory));
        this.registerOptimizer(new SquashLimit(intermediateOperationFactory));
        this.registerOptimizer(new SquashFilter(intermediateOperationFactory));
        this.registerOptimizer(new SquashSorted(intermediateOperationFactory));
        this.registerOptimizer(new SquashDistinct(intermediateOperationFactory));
    }

    public Stream<IntermediateOperationOptimizer> stream() {
        return this.intermediateOperationOptimizers.entrySet().stream().sorted(Map.Entry.comparingByKey(Enum::compareTo)).flatMap(x -> ((List)x.getValue()).stream());
    }

    private void registerOptimizer(IntermediateOperationOptimizer operationOptimizer) {
        Objects.requireNonNull(operationOptimizer);
        this.intermediateOperationOptimizers.get((Object)Priority.NORMAL).add(operationOptimizer);
    }

    private void registerOptimizer(IntermediateOperationOptimizer operationOptimizer, Priority priority) {
        Objects.requireNonNull(operationOptimizer);
        Objects.requireNonNull(priority);
        this.intermediateOperationOptimizers.get((Object)priority).add(operationOptimizer);
    }

    private static enum Priority {
        HIGHEST,
        HIGH,
        NORMAL,
        LOW,
        LOWEST;

    }
}

