/*
 *
 * Copyright (c) 2006-2020, Speedment, Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); You may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.speedment.common.tuple.internal.nullable;

import com.speedment.common.tuple.TupleOfNullables;
import com.speedment.common.tuple.internal.AbstractTupleOfNullables;
import com.speedment.common.tuple.nullable.Tuple15OfNullables;

import java.util.Optional;

/**
 * An implementation class of a {@link Tuple15OfNullables}.
 * <p>
 * Generated by com.speedment.sources.pattern.tuple.TupleImplPattern
 * 
 * @param <T0>  type of element 0
 * @param <T1>  type of element 1
 * @param <T2>  type of element 2
 * @param <T3>  type of element 3
 * @param <T4>  type of element 4
 * @param <T5>  type of element 5
 * @param <T6>  type of element 6
 * @param <T7>  type of element 7
 * @param <T8>  type of element 8
 * @param <T9>  type of element 9
 * @param <T10> type of element 10
 * @param <T11> type of element 11
 * @param <T12> type of element 12
 * @param <T13> type of element 13
 * @param <T14> type of element 14
 * 
 * @author Per Minborg
 */
public final class Tuple15OfNullablesImpl<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> 
extends AbstractTupleOfNullables 
implements Tuple15OfNullables<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> {
    
    /**
     * Constructs a {@link TupleOfNullables} of type {@link Tuple15OfNullables}.
     * 
     * @param e0  element 0
     * @param e1  element 1
     * @param e2  element 2
     * @param e3  element 3
     * @param e4  element 4
     * @param e5  element 5
     * @param e6  element 6
     * @param e7  element 7
     * @param e8  element 8
     * @param e9  element 9
     * @param e10 element 10
     * @param e11 element 11
     * @param e12 element 12
     * @param e13 element 13
     * @param e14 element 14
     */
    public Tuple15OfNullablesImpl(
            T0 e0,
            T1 e1,
            T2 e2,
            T3 e3,
            T4 e4,
            T5 e5,
            T6 e6,
            T7 e7,
            T8 e8,
            T9 e9,
            T10 e10,
            T11 e11,
            T12 e12,
            T13 e13,
            T14 e14) {
        super(Tuple15OfNullablesImpl.class, e0, e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14);
    }
    
    @SuppressWarnings("unchecked")
    @Override
    public Optional<T0> get0() {
        return Optional.ofNullable((T0) values[0]);
    }
    
    @SuppressWarnings("unchecked")
    @Override
    public Optional<T1> get1() {
        return Optional.ofNullable((T1) values[1]);
    }
    
    @SuppressWarnings("unchecked")
    @Override
    public Optional<T2> get2() {
        return Optional.ofNullable((T2) values[2]);
    }
    
    @SuppressWarnings("unchecked")
    @Override
    public Optional<T3> get3() {
        return Optional.ofNullable((T3) values[3]);
    }
    
    @SuppressWarnings("unchecked")
    @Override
    public Optional<T4> get4() {
        return Optional.ofNullable((T4) values[4]);
    }
    
    @SuppressWarnings("unchecked")
    @Override
    public Optional<T5> get5() {
        return Optional.ofNullable((T5) values[5]);
    }
    
    @SuppressWarnings("unchecked")
    @Override
    public Optional<T6> get6() {
        return Optional.ofNullable((T6) values[6]);
    }
    
    @SuppressWarnings("unchecked")
    @Override
    public Optional<T7> get7() {
        return Optional.ofNullable((T7) values[7]);
    }
    
    @SuppressWarnings("unchecked")
    @Override
    public Optional<T8> get8() {
        return Optional.ofNullable((T8) values[8]);
    }
    
    @SuppressWarnings("unchecked")
    @Override
    public Optional<T9> get9() {
        return Optional.ofNullable((T9) values[9]);
    }
    
    @SuppressWarnings("unchecked")
    @Override
    public Optional<T10> get10() {
        return Optional.ofNullable((T10) values[10]);
    }
    
    @SuppressWarnings("unchecked")
    @Override
    public Optional<T11> get11() {
        return Optional.ofNullable((T11) values[11]);
    }
    
    @SuppressWarnings("unchecked")
    @Override
    public Optional<T12> get12() {
        return Optional.ofNullable((T12) values[12]);
    }
    
    @SuppressWarnings("unchecked")
    @Override
    public Optional<T13> get13() {
        return Optional.ofNullable((T13) values[13]);
    }
    
    @SuppressWarnings("unchecked")
    @Override
    public Optional<T14> get14() {
        return Optional.ofNullable((T14) values[14]);
    }
}