/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.rest;

import com.speedment.common.rest.Option;
import com.speedment.common.rest.Response;
import com.speedment.common.rest.RestImpl;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;

public interface Rest {
    public CompletableFuture<Response> get(String var1, Option ... var2);

    public CompletableFuture<Response> post(String var1, Option ... var2);

    public CompletableFuture<Response> delete(String var1, Option ... var2);

    public CompletableFuture<Response> put(String var1, Option ... var2);

    public CompletableFuture<Response> options(String var1, Option ... var2);

    public CompletableFuture<Response> head(String var1, Option ... var2);

    public CompletableFuture<Response> get(String var1, InputStream var2, Option ... var3);

    public CompletableFuture<Response> post(String var1, InputStream var2, Option ... var3);

    public CompletableFuture<Response> delete(String var1, InputStream var2, Option ... var3);

    public CompletableFuture<Response> put(String var1, InputStream var2, Option ... var3);

    public CompletableFuture<Response> options(String var1, InputStream var2, Option ... var3);

    public CompletableFuture<Response> head(String var1, InputStream var2, Option ... var3);

    public CompletableFuture<Response> get(String var1, Iterator<String> var2, Option ... var3);

    public CompletableFuture<Response> post(String var1, Iterator<String> var2, Option ... var3);

    public CompletableFuture<Response> delete(String var1, Iterator<String> var2, Option ... var3);

    public CompletableFuture<Response> put(String var1, Iterator<String> var2, Option ... var3);

    public CompletableFuture<Response> options(String var1, Iterator<String> var2, Option ... var3);

    public CompletableFuture<Response> head(String var1, Iterator<String> var2, Option ... var3);

    public CompletableFuture<Response> get(String var1, String var2, Option ... var3);

    public CompletableFuture<Response> post(String var1, String var2, Option ... var3);

    public CompletableFuture<Response> delete(String var1, String var2, Option ... var3);

    public CompletableFuture<Response> put(String var1, String var2, Option ... var3);

    public CompletableFuture<Response> options(String var1, String var2, Option ... var3);

    public CompletableFuture<Response> head(String var1, String var2, Option ... var3);

    public static Rest connect(String host) {
        return new RestImpl(Protocol.HTTP, host, 0, null, null);
    }

    public static Rest connect(String host, int port) {
        return new RestImpl(Protocol.HTTP, host, port, null, null);
    }

    public static Rest connect(String host, String username, String password) {
        return new RestImpl(Protocol.HTTP, host, 0, username, password);
    }

    public static Rest connect(String host, int port, String username, String password) {
        return new RestImpl(Protocol.HTTP, host, port, username, password);
    }

    public static Rest connectHttps(String host) {
        return new RestImpl(Protocol.HTTPS, host, 0, null, null);
    }

    public static Rest connectHttps(String host, int port) {
        return new RestImpl(Protocol.HTTPS, host, port, null, null);
    }

    public static Rest connectHttps(String host, String username, String password) {
        return new RestImpl(Protocol.HTTPS, host, 0, username, password);
    }

    public static Rest connectHttps(String host, int port, String username, String password) {
        return new RestImpl(Protocol.HTTPS, host, port, username, password);
    }

    public static String encode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException("Error encoding value '" + value + "'.");
        }
    }

    public static enum Protocol {
        HTTP,
        HTTPS;

    }

    public static enum Method {
        POST,
        GET,
        DELETE,
        PUT,
        OPTIONS,
        HEAD;

    }
}

