/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.json;

import com.speedment.common.json.exception.JsonException;
import com.speedment.common.json.internal.JsonDeserializer;
import com.speedment.common.json.internal.JsonSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public final class Json {
    private Json() {
    }

    public static String toJson(Object object) {
        String string;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Json.toJson(object, out);
            string = new String(out.toByteArray(), StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new JsonException("Error in internal toString()-stream.", ex);
            }
        }
        out.close();
        return string;
    }

    public static String toJson(Object object, boolean pretty) {
        String string;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Json.toJson(object, out, pretty);
            string = new String(out.toByteArray(), StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new JsonException("Error in internal toString()-stream.", ex);
            }
        }
        out.close();
        return string;
    }

    public static void toJson(Object object, OutputStream out) throws IOException {
        Json.toJson(object, out, true);
    }

    public static void toJson(Object object, OutputStream out, boolean pretty) throws IOException {
        new JsonSerializer(out, pretty).print(object);
    }

    public static Object fromJson(String json) {
        Object object;
        ByteArrayInputStream stream = new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8));
        try {
            object = Json.fromJson(stream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new JsonException(ex);
            }
        }
        ((InputStream)stream).close();
        return object;
    }

    public static Object fromJson(InputStream in) throws IOException {
        try (JsonDeserializer parser = new JsonDeserializer(in);){
            Object object = parser.get();
            return object;
        }
    }
}

