/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.function;

import com.speedment.common.function.BooleanConsumer;
import com.speedment.common.function.BooleanPredicate;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Supplier;

public enum OptionalBoolean {
    FALSE{

        @Override
        public <T extends Throwable> boolean orElseThrow(Supplier<T> thrower) throws T {
            return false;
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public void ifPresent(BooleanConsumer consumer) {
            consumer.accept(false);
        }
    }
    ,
    TRUE{

        @Override
        public <T extends Throwable> boolean orElseThrow(Supplier<T> thrower) throws T {
            return true;
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public void ifPresent(BooleanConsumer consumer) {
            consumer.accept(true);
        }
    }
    ,
    EMPTY{

        @Override
        public <T extends Throwable> boolean orElseThrow(Supplier<T> thrower) throws T {
            throw (Throwable)thrower.get();
        }

        @Override
        public boolean isPresent() {
            return false;
        }

        @Override
        public void ifPresent(BooleanConsumer consumer) {
        }
    };


    public static OptionalBoolean empty() {
        return EMPTY;
    }

    public static OptionalBoolean of(boolean bool) {
        return bool ? TRUE : FALSE;
    }

    public static OptionalBoolean ofNullable(Boolean bool) {
        if (bool == null) {
            return OptionalBoolean.empty();
        }
        return OptionalBoolean.of(bool);
    }

    public OptionalBoolean filter(BooleanPredicate predicate) {
        Objects.requireNonNull(predicate);
        if (!this.isPresent()) {
            return this;
        }
        return predicate.test(this == TRUE) ? this : OptionalBoolean.empty();
    }

    public boolean getAsBoolean() {
        switch (this) {
            case FALSE: {
                return false;
            }
            case TRUE: {
                return true;
            }
        }
        throw new NoSuchElementException("Attempted to get value from empty OptionalBoolean.");
    }

    public boolean orElse(boolean ifEmpty) {
        switch (this) {
            case FALSE: {
                return false;
            }
            case TRUE: {
                return true;
            }
        }
        return ifEmpty;
    }

    public abstract <T extends Throwable> boolean orElseThrow(Supplier<T> var1) throws T;

    public abstract boolean isPresent();

    public abstract void ifPresent(BooleanConsumer var1);
}

