/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.internal.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;

public final class NullUtil {
    private NullUtil() {
    }

    public static <T, C extends Collection<T>> C requireNonNullElements(C collection) {
        Objects.requireNonNull(collection, "The provided collection is null.");
        collection.forEach(t -> {
            if (t == null) {
                throw new NullPointerException("An item in the collection is null.");
            }
        });
        return collection;
    }

    public static <T> T[] requireNonNullElements(T[] array) {
        Objects.requireNonNull(array, "The provided array is null.");
        int len = array.length;
        for (int i = 0; i < len; ++i) {
            if (array[i] != null) continue;
            throw new NullPointerException("Item " + i + " in the array " + Arrays.toString(array) + " is null");
        }
        return array;
    }

    public static <T> void requireNonNulls(T t0) {
        Objects.requireNonNull(t0, NullUtil.paramIsNullText(0));
    }

    public static <T> void requireNonNulls(T t0, T t1) {
        Objects.requireNonNull(t0, NullUtil.paramIsNullText(0));
        Objects.requireNonNull(t1, NullUtil.paramIsNullText(1));
    }

    public static <T> void requireNonNulls(T t0, T t1, T t2) {
        Objects.requireNonNull(t0, NullUtil.paramIsNullText(0));
        Objects.requireNonNull(t1, NullUtil.paramIsNullText(1));
        Objects.requireNonNull(t2, NullUtil.paramIsNullText(2));
    }

    private static String paramIsNullText(int x) {
        return "Parameter " + x + " is null.";
    }
}

