/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.internal.model;

import com.speedment.common.codegen.internal.util.Copier;
import com.speedment.common.codegen.model.ClassOrInterface;
import com.speedment.common.codegen.model.File;
import com.speedment.common.codegen.model.Import;
import com.speedment.common.codegen.model.Javadoc;
import com.speedment.common.codegen.model.LicenseTerm;
import com.speedment.common.codegen.model.trait.HasCopy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class FileImpl
implements File {
    private String name;
    private Javadoc doc;
    private LicenseTerm lic;
    private final List<Import> imports;
    private final List<ClassOrInterface<?>> classes;

    public FileImpl(String name) {
        this.name = Objects.requireNonNull(name);
        this.doc = null;
        this.imports = new ArrayList<Import>();
        this.classes = new ArrayList();
    }

    protected FileImpl(File prototype) {
        this.name = Objects.requireNonNull(prototype).getName();
        this.doc = prototype.getJavadoc().map(Copier::copy).orElse(null);
        this.imports = Copier.copy(prototype.getImports());
        this.classes = Copier.copy(prototype.getClasses(), HasCopy::copy);
    }

    @Override
    public File setName(String name) {
        this.name = Objects.requireNonNull(name);
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public File set(Javadoc doc) {
        this.doc = (Javadoc)doc.setParent(this);
        return this;
    }

    @Override
    public File set(LicenseTerm doc) {
        this.lic = (LicenseTerm)doc.setParent(this);
        return this;
    }

    @Override
    public Optional<Javadoc> getJavadoc() {
        return Optional.ofNullable(this.doc);
    }

    @Override
    public Optional<LicenseTerm> getLicenseTerm() {
        return Optional.ofNullable(this.lic);
    }

    @Override
    public List<Import> getImports() {
        return this.imports;
    }

    @Override
    public List<ClassOrInterface<?>> getClasses() {
        return this.classes;
    }

    @Override
    public FileImpl copy() {
        return new FileImpl(this);
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + Objects.hashCode(this.name);
        hash = 37 * hash + Objects.hashCode(this.doc);
        hash = 37 * hash + Objects.hashCode(this.lic);
        hash = 37 * hash + Objects.hashCode(this.imports);
        hash = 37 * hash + Objects.hashCode(this.classes);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileImpl other = (FileImpl)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.doc, other.doc)) {
            return false;
        }
        if (!Objects.equals(this.lic, other.lic)) {
            return false;
        }
        if (!Objects.equals(this.imports, other.imports)) {
            return false;
        }
        return Objects.equals(this.classes, other.classes);
    }
}

