/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.internal.model;

import com.speedment.common.codegen.internal.model.HashUtil;
import com.speedment.common.codegen.internal.util.Copier;
import com.speedment.common.codegen.model.AnnotationUsage;
import com.speedment.common.codegen.model.ClassOrInterface;
import com.speedment.common.codegen.model.Enum;
import com.speedment.common.codegen.model.EnumConstant;
import com.speedment.common.codegen.model.Field;
import com.speedment.common.codegen.model.Import;
import com.speedment.common.codegen.model.Initializer;
import com.speedment.common.codegen.model.Javadoc;
import com.speedment.common.codegen.model.Method;
import com.speedment.common.codegen.model.Value;
import com.speedment.common.codegen.model.trait.HasCopy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class EnumConstantImpl
implements EnumConstant {
    private Enum parent;
    private String name;
    private Javadoc javadoc;
    private final List<Import> imports;
    private final List<ClassOrInterface<?>> classes;
    private final List<Initializer> initializers;
    private final List<Method> methods;
    private final List<Field> fields;
    private final List<Value<?>> values;
    private final List<AnnotationUsage> annotations;

    public EnumConstantImpl(String name) {
        this.name = Objects.requireNonNull(name);
        this.imports = new ArrayList<Import>();
        this.classes = new ArrayList();
        this.initializers = new ArrayList<Initializer>();
        this.methods = new ArrayList<Method>();
        this.fields = new ArrayList<Field>();
        this.values = new ArrayList();
        this.annotations = new ArrayList<AnnotationUsage>();
    }

    protected EnumConstantImpl(EnumConstant prototype) {
        this.name = Objects.requireNonNull(prototype).getName();
        this.javadoc = prototype.getJavadoc().orElse(null);
        this.imports = Copier.copy(prototype.getImports());
        this.classes = Copier.copy(prototype.getClasses(), HasCopy::copy);
        this.initializers = Copier.copy(prototype.getInitializers(), HasCopy::copy);
        this.methods = Copier.copy(prototype.getMethods(), HasCopy::copy);
        this.fields = Copier.copy(prototype.getFields(), HasCopy::copy);
        this.values = Copier.copy(prototype.getValues(), HasCopy::copy);
        this.annotations = Copier.copy(prototype.getAnnotations(), HasCopy::copy);
    }

    @Override
    public EnumConstant setParent(Enum parent) {
        this.parent = parent;
        return this;
    }

    @Override
    public Optional<Enum> getParent() {
        return Optional.ofNullable(this.parent);
    }

    @Override
    public List<Import> getImports() {
        return this.imports;
    }

    @Override
    public EnumConstant setName(String name) {
        this.name = Objects.requireNonNull(name);
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Value<?>> getValues() {
        return this.values;
    }

    @Override
    public EnumConstant set(Javadoc doc) {
        this.javadoc = (Javadoc)doc.setParent(this);
        return this;
    }

    @Override
    public Optional<Javadoc> getJavadoc() {
        return Optional.ofNullable(this.javadoc);
    }

    @Override
    public List<ClassOrInterface<?>> getClasses() {
        return this.classes;
    }

    @Override
    public List<Initializer> getInitializers() {
        return this.initializers;
    }

    @Override
    public List<Method> getMethods() {
        return this.methods;
    }

    @Override
    public List<Field> getFields() {
        return this.fields;
    }

    @Override
    public List<AnnotationUsage> getAnnotations() {
        return this.annotations;
    }

    @Override
    public EnumConstantImpl copy() {
        return new EnumConstantImpl(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnumConstantImpl that = (EnumConstantImpl)o;
        return Objects.equals(this.parent, that.parent) && Objects.equals(this.name, that.name) && Objects.equals(this.javadoc, that.javadoc) && Objects.equals(this.imports, that.imports) && Objects.equals(this.classes, that.classes) && Objects.equals(this.initializers, that.initializers) && Objects.equals(this.methods, that.methods) && Objects.equals(this.fields, that.fields) && Objects.equals(this.values, that.values) && Objects.equals(this.annotations, that.annotations);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.javadoc, this.imports, this.classes, this.initializers, this.methods, this.fields, this.values, this.annotations) + HashUtil.identityHashForParent(this);
    }
}

