/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.internal.java.view;

import com.speedment.common.codegen.DependencyManager;
import com.speedment.common.codegen.Generator;
import com.speedment.common.codegen.Transform;
import com.speedment.common.codegen.internal.util.NullUtil;
import com.speedment.common.codegen.model.Import;
import com.speedment.common.codegen.util.CollectorUtil;
import com.speedment.common.codegen.util.Formatting;
import java.lang.reflect.Type;
import java.util.Optional;

public final class ImportView
implements Transform<Import, String> {
    @Override
    public Optional<String> transform(Generator gen, Import model) {
        NullUtil.requireNonNulls(gen, model);
        String name = Formatting.stripGenerics(model.getType().getTypeName()).replace('$', '.');
        if (!model.getModifiers().isEmpty() || this.shouldImport(gen, model.getType())) {
            return Optional.of("import " + gen.onEach(model.getModifiers()).collect(CollectorUtil.joinIfNotEmpty(" ", "", " ")) + name + model.getStaticMember().map(str -> "." + str).orElse("") + ";").filter(x -> {
                gen.getDependencyMgr().load(name);
                return true;
            });
        }
        return Optional.empty();
    }

    private boolean shouldImport(Generator gen, Type type) {
        String typeName;
        DependencyManager mgr = gen.getDependencyMgr();
        if (mgr.isIgnored(typeName = Formatting.stripGenerics(type.getTypeName()))) {
            return false;
        }
        if (mgr.isLoaded(typeName)) {
            return false;
        }
        Optional<String> current = mgr.getCurrentPackage();
        Optional<String> suggested = Formatting.packageName(typeName);
        return !current.isPresent() || !suggested.isPresent() || !current.get().equals(suggested.get());
    }
}

