/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.internal;

import com.speedment.common.codegen.Transform;
import com.speedment.common.codegen.TransformFactory;
import com.speedment.common.codegen.internal.util.NullUtil;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class TransformFactoryImpl
implements TransformFactory {
    private final Map<Class<?>, Set<Map.Entry<Class<?>, Supplier<? extends Transform<?, ?>>>>> transforms;
    private final String name;

    public TransformFactoryImpl(String name) {
        this.name = Objects.requireNonNull(name);
        this.transforms = new ConcurrentHashMap();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public <A, B, T extends Transform<A, B>> TransformFactory install(Class<A> from, Class<B> to, Supplier<T> transform) {
        NullUtil.requireNonNulls(from, to, transform);
        this.transforms.computeIfAbsent(from, f -> new HashSet()).add(new AbstractMap.SimpleEntry<Class<B>, Supplier<T>>(to, transform));
        return this;
    }

    @Override
    public <A, T extends Transform<A, ?>> Set<Map.Entry<Class<?>, T>> allFrom(Class<A> model) {
        Objects.requireNonNull(model);
        return this.transforms.entrySet().stream().filter(e -> ((Class)e.getKey()).isAssignableFrom(model)).flatMap(e -> ((Set)e.getValue()).stream()).map(e -> TransformFactoryImpl.toEntry((Class)e.getKey(), (Transform)((Supplier)e.getValue()).get())).collect(Collectors.toSet());
    }

    private static <A, T extends Transform<A, ?>> Map.Entry<Class<?>, T> toEntry(Class<?> key, T value) {
        return new AbstractMap.SimpleEntry(key, value);
    }
}

