/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.internal;

import com.speedment.common.codegen.DependencyManager;
import com.speedment.common.codegen.Generator;
import com.speedment.common.codegen.Meta;
import com.speedment.common.codegen.RenderStack;
import com.speedment.common.codegen.RenderTree;
import com.speedment.common.codegen.Transform;
import com.speedment.common.codegen.TransformFactory;
import com.speedment.common.codegen.internal.BridgeTransform;
import com.speedment.common.codegen.internal.DefaultRenderStack;
import com.speedment.common.codegen.internal.util.NullUtil;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public final class GeneratorImpl
implements Generator {
    private final DependencyManager mgr;
    private final TransformFactory factory;
    private final DefaultRenderStack renderStack;
    private final LinkedList<RenderTree.Builder> renderTreeBuilder;

    public GeneratorImpl(DependencyManager mgr, TransformFactory factory) {
        this.factory = Objects.requireNonNull(factory);
        this.mgr = Objects.requireNonNull(mgr);
        this.renderStack = new DefaultRenderStack();
        this.renderTreeBuilder = new LinkedList();
        this.renderTreeBuilder.add(RenderTree.builder());
    }

    @Override
    public DependencyManager getDependencyMgr() {
        return this.mgr;
    }

    @Override
    public RenderStack getRenderStack() {
        return this.renderStack;
    }

    @Override
    public <A, B> Stream<Meta<A, B>> metaOn(A from, Class<B> to) {
        NullUtil.requireNonNulls(from, to);
        if (from instanceof Optional) {
            throw new UnsupportedOperationException("Model must not be an Optional!");
        }
        return BridgeTransform.create(this.factory, from.getClass(), to).map(t -> t).map(t -> this.transform((Transform)t, from, this.factory)).filter(Optional::isPresent).map(Optional::get);
    }

    @Override
    public <A, B> Optional<Meta<A, B>> transform(Transform<A, B> transform, A model, TransformFactory factory) {
        NullUtil.requireNonNulls(transform, model, factory);
        RenderTree.Builder parent = this.renderTreeBuilder.peek();
        RenderTree.Builder branch = RenderTree.builder();
        this.renderTreeBuilder.push(branch);
        this.renderStack.push(model);
        Optional<Meta<A, B>> meta = transform.transform(this, model).map(s -> Meta.builder(model, s).withTransform(transform).withFactory(factory).withRenderTree(branch.build()).withRenderStack(new DefaultRenderStack(this.renderStack)).build());
        meta.ifPresent(parent::withBranch);
        this.renderStack.pop();
        this.renderTreeBuilder.pop();
        return meta;
    }
}

