/*
 * Decompiled with CFR 0.152.
 */
package spark.template.freemarker;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.Version;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import spark.ModelAndView;
import spark.TemplateEngine;

public class FreeMarkerEngine
extends TemplateEngine {
    private Configuration configuration;

    public FreeMarkerEngine() {
        this.configuration = this.createDefaultConfiguration();
    }

    public FreeMarkerEngine(Configuration configuration) {
        this.configuration = configuration;
    }

    public String render(ModelAndView modelAndView) {
        try {
            StringWriter stringWriter = new StringWriter();
            Template template = this.configuration.getTemplate(modelAndView.getViewName());
            template.process(modelAndView.getModel(), (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (TemplateException | IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Deprecated
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    private Configuration createDefaultConfiguration() {
        Configuration configuration = new Configuration(new Version(2, 3, 23));
        configuration.setClassForTemplateLoading(FreeMarkerEngine.class, "");
        return configuration;
    }
}

