/*
 * Decompiled with CFR 0.152.
 */
package spark.debug;

import com.google.common.base.Optional;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import spark.debug.Iterables;
import spark.debug.SourceLocator;

public class FileSearchSourceLocator
implements SourceLocator {
    private final File basePathFile;

    public FileSearchSourceLocator(String basePath) {
        this.basePathFile = new File(basePath);
    }

    @Override
    public Optional<File> findFileForFrame(final StackTraceElement frame) {
        if (frame.getFileName() == null) {
            return Optional.absent();
        }
        if (!(this.basePathFile.exists() && this.basePathFile.isDirectory() && this.basePathFile.canRead())) {
            return Optional.absent();
        }
        Collection<File> possibilities = FileUtils.listFiles(this.basePathFile, new IOFileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().equals(frame.getFileName());
            }

            @Override
            public boolean accept(File dir, String name) {
                return name.equals(frame.getFileName());
            }
        }, TrueFileFilter.INSTANCE);
        if (possibilities.size() == 1) {
            File file = Iterables.first(possibilities);
            return Optional.of(file);
        }
        if (possibilities.size() > 1) {
            String className = frame.getClassName();
            if (className.indexOf(36) != -1) {
                className = className.substring(0, className.lastIndexOf(36));
            }
            String path = File.separatorChar + className.replace('.', File.separatorChar) + ".java";
            try {
                for (File file : possibilities) {
                    if (!file.getCanonicalPath().endsWith(path)) continue;
                    return Optional.of(file);
                }
            }
            catch (IOException e) {
                return Optional.absent();
            }
            return Optional.absent();
        }
        return Optional.absent();
    }
}

