/*
 * Decompiled with CFR 0.152.
 */
package spark.webserver;

import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkServer {
    private static final int SPARK_DEFAULT_PORT = 4567;
    private static final String NAME = "Spark";
    private Handler handler;
    private Server server;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public SparkServer(Handler handler) {
        this.handler = handler;
        System.setProperty("org.mortbay.log.class", "spark.JettyLogger");
    }

    public void ignite(String host, int port, String keystoreFile, String keystorePassword, String truststoreFile, String truststorePassword, String staticFilesFolder, String externalFilesFolder, CountDownLatch latch, int maxThreads, int minThreads, int threadIdleTimeoutMillis) {
        if (port == 0) {
            try (ServerSocket s = new ServerSocket(0);){
                port = s.getLocalPort();
            }
            catch (IOException e) {
                this.logger.error("Could not get first available port (port set to 0), using default: {}", (Object)4567);
                port = 4567;
            }
        }
        this.server = SparkServer.createServer(maxThreads, minThreads, threadIdleTimeoutMillis);
        ServerConnector connector = keystoreFile == null ? SparkServer.createSocketConnector(this.server) : SparkServer.createSecureSocketConnector(this.server, keystoreFile, keystorePassword, truststoreFile, truststorePassword);
        connector.setIdleTimeout(TimeUnit.HOURS.toMillis(1L));
        connector.setSoLingerTime(-1);
        connector.setHost(host);
        connector.setPort(port);
        this.server = connector.getServer();
        this.server.setConnectors(new Connector[]{connector});
        if (staticFilesFolder == null && externalFilesFolder == null) {
            this.server.setHandler(this.handler);
        } else {
            ArrayList<Handler> handlersInList = new ArrayList<Handler>();
            handlersInList.add(this.handler);
            SparkServer.setStaticFileLocationIfPresent(staticFilesFolder, handlersInList);
            SparkServer.setExternalStaticFileLocationIfPresent(externalFilesFolder, handlersInList);
            HandlerList handlers = new HandlerList();
            handlers.setHandlers(handlersInList.toArray(new Handler[handlersInList.size()]));
            this.server.setHandler((Handler)handlers);
        }
        try {
            this.logger.info("== {} has ignited ...", (Object)NAME);
            this.logger.info(">> Listening on {}:{}", (Object)host, (Object)port);
            this.server.start();
            latch.countDown();
            this.server.join();
        }
        catch (Exception e) {
            this.logger.error("ignite failed", (Throwable)e);
            System.exit(100);
        }
    }

    public void stop() {
        this.logger.info(">>> {} shutting down ...", (Object)NAME);
        try {
            if (this.server != null) {
                this.server.stop();
            }
        }
        catch (Exception e) {
            this.logger.error("stop failed", (Throwable)e);
            System.exit(100);
        }
        this.logger.info("done");
    }

    private static ServerConnector createSecureSocketConnector(Server server, String keystoreFile, String keystorePassword, String truststoreFile, String truststorePassword) {
        SslContextFactory sslContextFactory = new SslContextFactory(keystoreFile);
        if (keystorePassword != null) {
            sslContextFactory.setKeyStorePassword(keystorePassword);
        }
        if (truststoreFile != null) {
            sslContextFactory.setTrustStorePath(truststoreFile);
        }
        if (truststorePassword != null) {
            sslContextFactory.setTrustStorePassword(truststorePassword);
        }
        return new ServerConnector(server, sslContextFactory);
    }

    private static ServerConnector createSocketConnector(Server server) {
        return new ServerConnector(server);
    }

    private static Server createServer(int maxThreads, int minThreads, int threadTimeoutMillis) {
        Server server;
        if (maxThreads > 0) {
            int max = maxThreads > 0 ? maxThreads : 200;
            int min = minThreads > 0 ? minThreads : 8;
            int idleTimeout = threadTimeoutMillis > 0 ? threadTimeoutMillis : 60000;
            server = new Server((ThreadPool)new QueuedThreadPool(max, min, idleTimeout));
        } else {
            server = new Server();
        }
        return server;
    }

    private static void setStaticFileLocationIfPresent(String staticFilesRoute, List<Handler> handlersInList) {
        if (staticFilesRoute != null) {
            ResourceHandler resourceHandler = new ResourceHandler();
            Resource staticResources = Resource.newClassPathResource((String)staticFilesRoute);
            resourceHandler.setBaseResource(staticResources);
            resourceHandler.setWelcomeFiles(new String[]{"index.html"});
            handlersInList.add((Handler)resourceHandler);
        }
    }

    private static void setExternalStaticFileLocationIfPresent(String externalFilesRoute, List<Handler> handlersInList) {
        if (externalFilesRoute != null) {
            try {
                ResourceHandler externalResourceHandler = new ResourceHandler();
                Resource externalStaticResources = Resource.newResource((File)new File(externalFilesRoute));
                externalResourceHandler.setBaseResource(externalStaticResources);
                externalResourceHandler.setWelcomeFiles(new String[]{"index.html"});
                handlersInList.add((Handler)externalResourceHandler);
            }
            catch (IOException exception) {
                exception.printStackTrace();
                System.err.println("Error during initialize external resource " + externalFilesRoute);
            }
        }
    }
}

