/*
 * Decompiled with CFR 0.152.
 */
package spark.route;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.route.HttpMethod;
import spark.route.RouteEntry;
import spark.route.RouteMatch;
import spark.utils.MimeParse;
import spark.utils.StringUtils;

public class SimpleRouteMatcher {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleRouteMatcher.class);
    private static final char SINGLE_QUOTE = '\'';
    private List<RouteEntry> routes = new ArrayList<RouteEntry>();

    public void parseValidateAddRoute(String route, String acceptType, Object target) {
        try {
            HttpMethod method;
            int singleQuoteIndex = route.indexOf(39);
            String httpMethod = route.substring(0, singleQuoteIndex).trim().toLowerCase();
            String url = route.substring(singleQuoteIndex + 1, route.length() - 1).trim();
            try {
                method = HttpMethod.valueOf(httpMethod);
            }
            catch (IllegalArgumentException e) {
                LOG.error("The @Route value: " + route + " has an invalid HTTP method part: " + httpMethod + ".");
                return;
            }
            this.addRoute(method, url, acceptType, target);
        }
        catch (Exception e) {
            LOG.error("The @Route value: " + route + " is not in the correct format", (Throwable)e);
        }
    }

    public RouteMatch findTargetForRequestedRoute(HttpMethod httpMethod, String path, String acceptType) {
        List<RouteEntry> routeEntries = this.findTargetsForRequestedRoute(httpMethod, path);
        RouteEntry entry = this.findTargetWithGivenAcceptType(routeEntries, acceptType);
        return entry != null ? new RouteMatch(httpMethod, entry.target, entry.path, path, acceptType) : null;
    }

    public List<RouteMatch> findTargetsForRequestedRoute(HttpMethod httpMethod, String path, String acceptType) {
        ArrayList<RouteMatch> matchSet = new ArrayList<RouteMatch>();
        List<RouteEntry> routeEntries = this.findTargetsForRequestedRoute(httpMethod, path);
        for (RouteEntry routeEntry : routeEntries) {
            if (acceptType != null) {
                String bestMatch = MimeParse.bestMatch(Arrays.asList(routeEntry.acceptedType), acceptType);
                if (!this.routeWithGivenAcceptType(bestMatch)) continue;
                matchSet.add(new RouteMatch(httpMethod, routeEntry.target, routeEntry.path, path, acceptType));
                continue;
            }
            matchSet.add(new RouteMatch(httpMethod, routeEntry.target, routeEntry.path, path, acceptType));
        }
        return matchSet;
    }

    public void clearRoutes() {
        this.routes.clear();
    }

    public boolean removeRoute(String path, String httpMethod) {
        if (StringUtils.isEmpty(path)) {
            throw new IllegalArgumentException("path cannot be null or blank");
        }
        if (StringUtils.isEmpty(httpMethod)) {
            throw new IllegalArgumentException("httpMethod cannot be null or blank");
        }
        HttpMethod method = HttpMethod.valueOf(httpMethod);
        return this.removeRoute(method, path);
    }

    public boolean removeRoute(String path) {
        if (StringUtils.isEmpty(path)) {
            throw new IllegalArgumentException("path cannot be null or blank");
        }
        return this.removeRoute((HttpMethod)null, path);
    }

    private void addRoute(HttpMethod method, String url, String acceptedType, Object target) {
        RouteEntry entry = new RouteEntry();
        entry.httpMethod = method;
        entry.path = url;
        entry.target = target;
        entry.acceptedType = acceptedType;
        LOG.debug("Adds route: " + entry);
        this.routes.add(entry);
    }

    private Map<String, RouteEntry> getAcceptedMimeTypes(List<RouteEntry> routes) {
        HashMap<String, RouteEntry> acceptedTypes = new HashMap<String, RouteEntry>();
        for (RouteEntry routeEntry : routes) {
            if (acceptedTypes.containsKey(routeEntry.acceptedType)) continue;
            acceptedTypes.put(routeEntry.acceptedType, routeEntry);
        }
        return acceptedTypes;
    }

    private boolean routeWithGivenAcceptType(String bestMatch) {
        return !"".equals(bestMatch);
    }

    private List<RouteEntry> findTargetsForRequestedRoute(HttpMethod httpMethod, String path) {
        ArrayList<RouteEntry> matchSet = new ArrayList<RouteEntry>();
        for (RouteEntry entry : this.routes) {
            if (!entry.matches(httpMethod, path)) continue;
            matchSet.add(entry);
        }
        return matchSet;
    }

    private RouteEntry findTargetWithGivenAcceptType(List<RouteEntry> routeMatches, String acceptType) {
        if (acceptType != null && routeMatches.size() > 0) {
            Map<String, RouteEntry> acceptedMimeTypes = this.getAcceptedMimeTypes(routeMatches);
            String bestMatch = MimeParse.bestMatch(acceptedMimeTypes.keySet(), acceptType);
            if (this.routeWithGivenAcceptType(bestMatch)) {
                return acceptedMimeTypes.get(bestMatch);
            }
            return null;
        }
        if (routeMatches.size() > 0) {
            return routeMatches.get(0);
        }
        return null;
    }

    private boolean removeRoute(HttpMethod httpMethod, String path) {
        ArrayList<RouteEntry> forRemoval = new ArrayList<RouteEntry>();
        for (RouteEntry routeEntry : this.routes) {
            HttpMethod httpMethodToMatch = httpMethod;
            if (httpMethod == null) {
                httpMethodToMatch = routeEntry.httpMethod;
            }
            if (!routeEntry.matches(httpMethodToMatch, path)) continue;
            LOG.debug("Removing path {}", (Object)path, (Object)(httpMethod == null ? "" : " with HTTP method " + (Object)((Object)httpMethod)));
            forRemoval.add(routeEntry);
        }
        return this.routes.removeAll(forRemoval);
    }
}

