/*
 * Decompiled with CFR 0.152.
 */
package spark;

import java.util.Enumeration;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpSession;

public class Session {
    private HttpSession session;

    Session(HttpSession session) {
        if (session == null) {
            throw new IllegalArgumentException("session cannot be null");
        }
        this.session = session;
    }

    public HttpSession raw() {
        return this.session;
    }

    public <T> T attribute(String name) {
        return (T)this.session.getAttribute(name);
    }

    public void attribute(String name, Object value) {
        this.session.setAttribute(name, value);
    }

    public Set<String> attributes() {
        TreeSet<String> attributes = new TreeSet<String>();
        Enumeration enumeration = this.session.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            attributes.add((String)enumeration.nextElement());
        }
        return attributes;
    }

    public long creationTime() {
        return this.session.getCreationTime();
    }

    public String id() {
        return this.session.getId();
    }

    public long lastAccessedTime() {
        return this.session.getLastAccessedTime();
    }

    public int maxInactiveInterval() {
        return this.session.getMaxInactiveInterval();
    }

    public void maxInactiveInterval(int interval) {
        this.session.setMaxInactiveInterval(interval);
    }

    public void invalidate() {
        this.session.invalidate();
    }

    public boolean isNew() {
        return this.session.isNew();
    }

    public void removeAttribute(String name) {
        this.session.removeAttribute(name);
    }
}

