/*
 * Decompiled with CFR 0.152.
 */
package com.soundcloud.android.crop;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapRegionDecoder;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.net.Uri;
import android.opengl.GLES10;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.view.View;
import com.soundcloud.android.crop.CropImageView;
import com.soundcloud.android.crop.CropUtil;
import com.soundcloud.android.crop.HighlightView;
import com.soundcloud.android.crop.ImageViewTouchBase;
import com.soundcloud.android.crop.Log;
import com.soundcloud.android.crop.MonitoredActivity;
import com.soundcloud.android.crop.R;
import com.soundcloud.android.crop.RotateBitmap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;

public class CropImageActivity
extends MonitoredActivity {
    private static final int SIZE_DEFAULT = 2048;
    private static final int SIZE_LIMIT = 4096;
    private final Handler handler = new Handler();
    private int aspectX;
    private int aspectY;
    private int maxX;
    private int maxY;
    private int exifRotation;
    private Uri sourceUri;
    private Uri saveUri;
    private boolean isSaving;
    private int sampleSize;
    private RotateBitmap rotateBitmap;
    private CropImageView imageView;
    private HighlightView cropView;

    @Override
    public void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.requestWindowFeature(1);
        this.setContentView(R.layout.crop__activity_crop);
        this.initViews();
        this.setupFromIntent();
        if (this.rotateBitmap == null) {
            this.finish();
            return;
        }
        this.startCrop();
    }

    private void initViews() {
        this.imageView = (CropImageView)this.findViewById(R.id.crop_image);
        this.imageView.context = this;
        this.imageView.setRecycler(new ImageViewTouchBase.Recycler(){

            @Override
            public void recycle(Bitmap b) {
                b.recycle();
                System.gc();
            }
        });
        this.findViewById(R.id.btn_cancel).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CropImageActivity.this.setResult(0);
                CropImageActivity.this.finish();
            }
        });
        this.findViewById(R.id.btn_done).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CropImageActivity.this.onSaveClicked();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void setupFromIntent() {
        Intent intent = this.getIntent();
        Bundle extras = intent.getExtras();
        if (extras != null) {
            this.aspectX = extras.getInt("aspect_x");
            this.aspectY = extras.getInt("aspect_y");
            this.maxX = extras.getInt("max_x");
            this.maxY = extras.getInt("max_y");
            this.saveUri = (Uri)extras.getParcelable("output");
        }
        this.sourceUri = intent.getData();
        if (this.sourceUri != null) {
            this.exifRotation = CropUtil.getExifRotation(CropUtil.getFromMediaUri((Context)this, this.getContentResolver(), this.sourceUri));
            InputStream is = null;
            try {
                this.sampleSize = this.calculateBitmapSampleSize(this.sourceUri);
                is = this.getContentResolver().openInputStream(this.sourceUri);
                BitmapFactory.Options option = new BitmapFactory.Options();
                option.inSampleSize = this.sampleSize;
                this.rotateBitmap = new RotateBitmap(BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)option), this.exifRotation);
            }
            catch (IOException e) {
                Log.e("Error reading image: " + e.getMessage(), e);
                this.setResultException(e);
                CropUtil.closeSilently(is);
            }
            catch (OutOfMemoryError e2) {
                Log.e("OOM reading image: " + e2.getMessage(), e2);
                this.setResultException(e2);
                {
                    catch (Throwable throwable) {
                        CropUtil.closeSilently(is);
                        throw throwable;
                    }
                }
                CropUtil.closeSilently(is);
            }
            CropUtil.closeSilently(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int calculateBitmapSampleSize(Uri bitmapUri) throws IOException {
        InputStream is = null;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        try {
            is = this.getContentResolver().openInputStream(bitmapUri);
            BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
        }
        catch (Throwable throwable) {
            CropUtil.closeSilently(is);
            throw throwable;
        }
        CropUtil.closeSilently(is);
        int maxSize = this.getMaxImageSize();
        int sampleSize = 1;
        while (options.outHeight / sampleSize > maxSize || options.outWidth / sampleSize > maxSize) {
            sampleSize <<= 1;
        }
        return sampleSize;
    }

    private int getMaxImageSize() {
        int textureLimit = this.getMaxTextureSize();
        if (textureLimit == 0) {
            return 2048;
        }
        return Math.min(textureLimit, 4096);
    }

    private int getMaxTextureSize() {
        int[] maxSize = new int[1];
        GLES10.glGetIntegerv((int)3379, (int[])maxSize, (int)0);
        return maxSize[0];
    }

    private void startCrop() {
        if (this.isFinishing()) {
            return;
        }
        this.imageView.setImageRotateBitmapResetBase(this.rotateBitmap, true);
        CropUtil.startBackgroundJob(this, null, this.getResources().getString(R.string.crop__wait), new Runnable(){

            @Override
            public void run() {
                final CountDownLatch latch = new CountDownLatch(1);
                CropImageActivity.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (CropImageActivity.this.imageView.getScale() == 1.0f) {
                            CropImageActivity.this.imageView.center(true, true);
                        }
                        latch.countDown();
                    }
                });
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                new Cropper().crop();
            }
        }, this.handler);
    }

    private void onSaveClicked() {
        Bitmap croppedImage;
        if (this.cropView == null || this.isSaving) {
            return;
        }
        this.isSaving = true;
        Rect r = this.cropView.getScaledCropRect(this.sampleSize);
        int width = r.width();
        int height = r.height();
        int outWidth = width;
        int outHeight = height;
        if (this.maxX > 0 && this.maxY > 0 && (width > this.maxX || height > this.maxY)) {
            float ratio = (float)width / (float)height;
            if ((float)this.maxX / (float)this.maxY > ratio) {
                outHeight = this.maxY;
                outWidth = (int)((float)this.maxY * ratio + 0.5f);
            } else {
                outWidth = this.maxX;
                outHeight = (int)((float)this.maxX / ratio + 0.5f);
            }
        }
        try {
            croppedImage = this.decodeRegionCrop(r, outWidth, outHeight);
        }
        catch (IllegalArgumentException e) {
            this.setResultException(e);
            this.finish();
            return;
        }
        if (croppedImage != null) {
            this.imageView.setImageRotateBitmapResetBase(new RotateBitmap(croppedImage, this.exifRotation), true);
            this.imageView.center(true, true);
            this.imageView.highlightViews.clear();
        }
        this.saveImage(croppedImage);
    }

    private void saveImage(Bitmap croppedImage) {
        if (croppedImage != null) {
            final Bitmap b = croppedImage;
            CropUtil.startBackgroundJob(this, null, this.getResources().getString(R.string.crop__saving), new Runnable(){

                @Override
                public void run() {
                    CropImageActivity.this.saveOutput(b);
                }
            }, this.handler);
        } else {
            this.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Bitmap decodeRegionCrop(Rect rect, int outWidth, int outHeight) {
        this.clearImageView();
        InputStream is = null;
        Bitmap croppedImage = null;
        try {
            Matrix matrix;
            is = this.getContentResolver().openInputStream(this.sourceUri);
            BitmapRegionDecoder decoder = BitmapRegionDecoder.newInstance((InputStream)is, (boolean)false);
            int width = decoder.getWidth();
            int height = decoder.getHeight();
            if (this.exifRotation != 0) {
                matrix = new Matrix();
                matrix.setRotate((float)(-this.exifRotation));
                RectF adjusted = new RectF();
                matrix.mapRect(adjusted, new RectF(rect));
                adjusted.offset(adjusted.left < 0.0f ? (float)width : 0.0f, adjusted.top < 0.0f ? (float)height : 0.0f);
                rect = new Rect((int)adjusted.left, (int)adjusted.top, (int)adjusted.right, (int)adjusted.bottom);
            }
            try {
                croppedImage = decoder.decodeRegion(rect, new BitmapFactory.Options());
                if (rect.width() > outWidth || rect.height() > outHeight) {
                    matrix = new Matrix();
                    matrix.postScale((float)outWidth / (float)rect.width(), (float)outHeight / (float)rect.height());
                    croppedImage = Bitmap.createBitmap((Bitmap)croppedImage, (int)0, (int)0, (int)croppedImage.getWidth(), (int)croppedImage.getHeight(), (Matrix)matrix, (boolean)true);
                }
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Rectangle " + rect + " is outside of the image (" + width + "," + height + "," + this.exifRotation + ")", e);
            }
        }
        catch (IOException e) {
            Log.e("Error cropping image: " + e.getMessage(), e);
            this.finish();
            CropUtil.closeSilently(is);
        }
        catch (OutOfMemoryError e2) {
            Log.e("OOM cropping image: " + e2.getMessage(), e2);
            this.setResultException(e2);
            {
                catch (Throwable throwable) {
                    CropUtil.closeSilently(is);
                    throw throwable;
                }
            }
            CropUtil.closeSilently(is);
        }
        CropUtil.closeSilently(is);
        return croppedImage;
    }

    private void clearImageView() {
        this.imageView.clear();
        if (this.rotateBitmap != null) {
            this.rotateBitmap.recycle();
        }
        System.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveOutput(Bitmap croppedImage) {
        block5: {
            OutputStream outputStream;
            block4: {
                if (this.saveUri == null) break block5;
                outputStream = null;
                try {
                    outputStream = this.getContentResolver().openOutputStream(this.saveUri);
                    if (outputStream == null) break block4;
                    croppedImage.compress(Bitmap.CompressFormat.JPEG, 90, outputStream);
                }
                catch (IOException e) {
                    try {
                        this.setResultException(e);
                        Log.e("Cannot open file: " + this.saveUri, e);
                    }
                    catch (Throwable throwable) {
                        CropUtil.closeSilently(outputStream);
                        throw throwable;
                    }
                    CropUtil.closeSilently(outputStream);
                }
            }
            CropUtil.closeSilently(outputStream);
            CropUtil.copyExifRotation(CropUtil.getFromMediaUri((Context)this, this.getContentResolver(), this.sourceUri), CropUtil.getFromMediaUri((Context)this, this.getContentResolver(), this.saveUri));
            this.setResultUri(this.saveUri);
        }
        final Bitmap b = croppedImage;
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                CropImageActivity.this.imageView.clear();
                b.recycle();
            }
        });
        this.finish();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.rotateBitmap != null) {
            this.rotateBitmap.recycle();
        }
    }

    public boolean onSearchRequested() {
        return false;
    }

    public boolean isSaving() {
        return this.isSaving;
    }

    private void setResultUri(Uri uri) {
        this.setResult(-1, new Intent().putExtra("output", (Parcelable)uri));
    }

    private void setResultException(Throwable throwable) {
        this.setResult(404, new Intent().putExtra("error", (Serializable)throwable));
    }

    private class Cropper {
        private Cropper() {
        }

        private void makeDefault() {
            int cropWidth;
            if (CropImageActivity.this.rotateBitmap == null) {
                return;
            }
            HighlightView hv = new HighlightView((View)CropImageActivity.this.imageView);
            int width = CropImageActivity.this.rotateBitmap.getWidth();
            int height = CropImageActivity.this.rotateBitmap.getHeight();
            Rect imageRect = new Rect(0, 0, width, height);
            int cropHeight = cropWidth = Math.min(width, height) * 4 / 5;
            if (CropImageActivity.this.aspectX != 0 && CropImageActivity.this.aspectY != 0) {
                if (CropImageActivity.this.aspectX > CropImageActivity.this.aspectY) {
                    cropHeight = cropWidth * CropImageActivity.this.aspectY / CropImageActivity.this.aspectX;
                } else {
                    cropWidth = cropHeight * CropImageActivity.this.aspectX / CropImageActivity.this.aspectY;
                }
            }
            int x = (width - cropWidth) / 2;
            int y = (height - cropHeight) / 2;
            RectF cropRect = new RectF((float)x, (float)y, (float)(x + cropWidth), (float)(y + cropHeight));
            hv.setup(CropImageActivity.this.imageView.getUnrotatedMatrix(), imageRect, cropRect, CropImageActivity.this.aspectX != 0 && CropImageActivity.this.aspectY != 0);
            CropImageActivity.this.imageView.add(hv);
        }

        public void crop() {
            CropImageActivity.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    Cropper.this.makeDefault();
                    CropImageActivity.this.imageView.invalidate();
                    if (((CropImageActivity)CropImageActivity.this).imageView.highlightViews.size() == 1) {
                        CropImageActivity.this.cropView = ((CropImageActivity)CropImageActivity.this).imageView.highlightViews.get(0);
                        CropImageActivity.this.cropView.setFocus(true);
                    }
                }
            });
        }
    }
}

