/*
 * Decompiled with CFR 0.152.
 */
package com.somospnt.test.util;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;

public class PropertiesUtil {
    private static final Map<String, PropertiesUtil> propertiesMap = new HashMap<String, PropertiesUtil>();
    private Properties properties;

    private PropertiesUtil() {
    }

    public static PropertiesUtil fromSpringApplication() {
        return PropertiesUtil.from("application.properties");
    }

    public static synchronized PropertiesUtil from(String resource) {
        PropertiesUtil propertiesUtil = propertiesMap.get(resource);
        if (propertiesUtil == null) {
            propertiesUtil = new PropertiesUtil();
            propertiesUtil.properties = PropertiesUtil.loadProperties(resource);
            propertiesMap.put(resource, propertiesUtil);
        }
        return propertiesUtil;
    }

    private static Properties loadProperties(String resource) {
        Properties prop = new Properties();
        try {
            prop.load(PropertiesUtil.class.getClassLoader().getResourceAsStream(resource));
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't load file: " + resource, ex);
        }
        return prop;
    }

    public String getProperty(String key) {
        String value = this.properties.getProperty(key);
        if (value == null) {
            throw new NoSuchElementException("Can't find property: " + key);
        }
        return value;
    }
}

