/*
 * Decompiled with CFR 0.152.
 */
package com.somospnt.loaderlib.factory;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.springframework.batch.item.file.LineMapper;
import org.springframework.batch.item.file.mapping.BeanWrapperFieldSetMapper;
import org.springframework.batch.item.file.mapping.DefaultLineMapper;
import org.springframework.batch.item.file.transform.DelimitedLineTokenizer;
import org.springframework.batch.item.file.transform.LineTokenizer;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.util.Assert;
import org.springframework.validation.DataBinder;

public class LineMapperFactory {
    public static <T> LineMapper<T> crear(Class<T> clase, String ... nombresAtributos) {
        LineMapperFactory.verificarAtributosExistenEnClase(clase, nombresAtributos);
        DefaultLineMapper lineMapper = new DefaultLineMapper();
        CustomBeanWrapperFieldSetMapper mapper = new CustomBeanWrapperFieldSetMapper();
        mapper.setTargetType(clase);
        mapper.setDistanceLimit(0);
        lineMapper.setFieldSetMapper(mapper);
        DelimitedLineTokenizer tokenizer = new DelimitedLineTokenizer();
        tokenizer.setDelimiter("|");
        tokenizer.setNames(nombresAtributos);
        lineMapper.setLineTokenizer((LineTokenizer)tokenizer);
        return lineMapper;
    }

    private static void verificarAtributosExistenEnClase(Class clase, String ... nombresCampos) {
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(clase);
        for (String nombreCampo : nombresCampos) {
            Assert.isTrue((boolean)beanWrapper.isWritableProperty(nombreCampo), (String)("El campo a leer: '" + nombreCampo + "' no existe en la clase " + clase.getName()));
        }
    }

    private static class CustomBeanWrapperFieldSetMapper<T>
    extends BeanWrapperFieldSetMapper<T> {
        private CustomBeanWrapperFieldSetMapper() {
        }

        protected void initBinder(DataBinder binder) {
            binder.registerCustomEditor(LocalDate.class, (PropertyEditor)new PropertyEditorSupport(){

                @Override
                public void setAsText(String text) throws IllegalArgumentException {
                    this.setValue("".equals(text) ? null : LocalDate.parse(text, DateTimeFormatter.ofPattern("yyyyMMdd")));
                }
            });
            binder.registerCustomEditor(String.class, (PropertyEditor)new PropertyEditorSupport(){

                @Override
                public void setAsText(String text) throws IllegalArgumentException {
                    this.setValue("".equals(text) ? null : text);
                }
            });
        }
    }
}

