/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */
package com.somospnt.loaderlib.config;

import com.somospnt.loaderlib.controller.LoaderController;
import com.somospnt.loaderlib.service.LoaderService;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;

@Configuration
@EnableGlobalMethodSecurity(prePostEnabled = true)
public class LoaderControllerAutoConfiguration {

    @Bean
    public LoaderController loaderController(LoaderService loaderService) {
        return new LoaderController(loaderService);
    }

}
