/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms;

import com.solacesystems.jms.SolTopicConnection;
import com.solacesystems.jms.SolXASession;
import com.solacesystems.jms.SolXATopicSession;
import com.solacesystems.jms.impl.SessionTransactionType;
import com.solacesystems.jms.impl.Validator;
import com.solacesystems.jms.property.JMSProperties;
import javax.jms.JMSException;
import javax.jms.XASession;
import javax.jms.XATopicConnection;
import javax.jms.XATopicSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SolXATopicConnection
extends SolTopicConnection
implements XATopicConnection {
    private static final Log log = LogFactory.getLog(SolXATopicConnection.class);

    public SolXATopicConnection(JMSProperties properties) throws JMSException {
        super(properties, true);
    }

    public SolXATopicConnection(JMSProperties properties, String userName, String password) throws JMSException {
        super(properties, true, userName, password);
    }

    public XASession createXASession() throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entering createXASession()");
        }
        this.checkClosed();
        Validator.checkTransactedAndAckMode(SessionTransactionType.XATransaction, 0, this.mConnectionProps.getPropertyBean().getDirectTransport());
        Validator.checkTransactedAndLargeMessaging(SessionTransactionType.XATransaction, this.mJCSMPProperties.getBooleanProperty("large_messaging"));
        this.mHasBeenAccessed = true;
        SolXASession newSession = new SolXASession(this, this.mState);
        this.mSessions.add(newSession);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Leaving createXASession()");
        }
        return newSession;
    }

    public XATopicSession createXATopicSession() throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entering createXATopicSession()");
        }
        Validator.checkTransactedAndLargeMessaging(SessionTransactionType.XATransaction, this.mJCSMPProperties.getBooleanProperty("large_messaging"));
        this.checkClosed();
        Validator.checkTransactedAndAckMode(SessionTransactionType.XATransaction, 0, this.mConnectionProps.getPropertyBean().getDirectTransport());
        this.mHasBeenAccessed = true;
        SolXATopicSession newSession = new SolXATopicSession(this, this.mState);
        this.mSessions.add(newSession);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Leaving createXATopicSession()");
        }
        return newSession;
    }
}

