/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.smf.impl;

import com.solacesystems.common.util.BitTwiddleUtil;
import com.solacesystems.common.util.NetworkByteOrderNumberUtil;
import com.solacesystems.jcsmp.protocol.HeaderDescriptionBean;
import com.solacesystems.jcsmp.protocol.WireDecoder;
import com.solacesystems.jcsmp.protocol.smf.PubCtrlHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.PubCtrlHeaderParameters;
import com.solacesystems.jcsmp.protocol.smf.PubSubCtrlHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.SubCtrlHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.SubCtrlHeaderParameters;
import com.solacesystems.jcsmp.protocol.smf.impl.NetworkIOUtil;
import com.solacesystems.jcsmp.protocol.smf.impl.SMFNumericConstants;
import com.solacesystems.jcsmp.protocol.smf.impl.TlvCoderUtil;
import java.io.IOException;
import java.io.InputStream;

public class PubSubCtrlHeaderDecoder
implements SMFNumericConstants,
WireDecoder {
    public void decodeHeader(InputStream in, HeaderDescriptionBean headerBean) throws IOException {
        block4: {
            int guard;
            int bytesRead;
            int reportedLenBytes;
            PubSubCtrlHeaderBean h;
            block3: {
                if (!(headerBean instanceof PubSubCtrlHeaderBean)) {
                    throw new IllegalArgumentException();
                }
                h = (PubSubCtrlHeaderBean)headerBean;
                int hdrLenWords = 0;
                reportedLenBytes = 0;
                bytesRead = 0;
                byte[] onebyte = new byte[1];
                byte[] twobytes = new byte[2];
                NetworkIOUtil.readDataSafely(in, onebyte, 0, 1);
                long onebyteLong = NetworkByteOrderNumberUtil.oneByteToUInt(onebyte[0]);
                h.setProtocolVersion((int)BitTwiddleUtil.extractBits(onebyteLong, 6L, 0L));
                NetworkIOUtil.readDataSafely(in, twobytes, 0, 2);
                long twobytesLong = NetworkByteOrderNumberUtil.twoByteToUInt(twobytes);
                hdrLenWords = (int)BitTwiddleUtil.extractBits(twobytesLong, 12L, 0L);
                reportedLenBytes = hdrLenWords * 4;
                bytesRead += 3;
                guard = 100;
                if (!(h instanceof PubCtrlHeaderBean)) break block3;
                while (bytesRead < reportedLenBytes) {
                    bytesRead = TlvCoderUtil.readTlvParam(in, bytesRead, reportedLenBytes, h, PubCtrlHeaderParameters.KNOWN_PARAMS);
                    if (guard-- > 0) continue;
                    throw new IOException("Error parsing parameters, invalid message.");
                }
                break block4;
            }
            if (!(h instanceof SubCtrlHeaderBean)) break block4;
            while (bytesRead < reportedLenBytes) {
                bytesRead = TlvCoderUtil.readTlvParam(in, bytesRead, reportedLenBytes, h, SubCtrlHeaderParameters.KNOWN_PARAMS);
                if (guard-- > 0) continue;
                throw new IOException("Error parsing parameters, invalid message.");
            }
        }
    }
}

