/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.smf.impl;

import com.solacesystems.common.util.BitTwiddleUtil;
import com.solacesystems.common.util.NetworkByteOrderNumberUtil;
import com.solacesystems.jcsmp.protocol.HeaderDescriptionBean;
import com.solacesystems.jcsmp.protocol.WireEncoder;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.SmfTLVParameter;
import com.solacesystems.jcsmp.protocol.smf.impl.GrowableByteBuffer;
import com.solacesystems.jcsmp.protocol.smf.impl.TlvCoderUtil;
import java.io.IOException;
import java.io.OutputStream;

public class AssuredCtrlHeaderEncoder
implements WireEncoder {
    GrowableByteBuffer buf = GrowableByteBuffer.allocate(10000);

    public void encodeHeader(OutputStream out, HeaderDescriptionBean headerBean) throws IOException {
        if (!(headerBean instanceof AssuredCtrlHeaderBean)) {
            throw new IllegalArgumentException();
        }
        AssuredCtrlHeaderBean h = (AssuredCtrlHeaderBean)headerBean;
        this.buf.clear();
        if (h.getAssuredCtrlVersion() <= 2) {
            int lenBytes = h.getSmfEncodedLength();
            while (lenBytes % 4 != 0) {
                ++lenBytes;
            }
            long tmplong = 0L;
            tmplong = BitTwiddleUtil.setBits(tmplong, h.getAssuredCtrlVersion(), 6, 16);
            tmplong = BitTwiddleUtil.setBits(tmplong, h.getMsgType(), 4, 12);
            tmplong = BitTwiddleUtil.setBits(tmplong, lenBytes / 4, 12, 0);
            byte[] fourbytes = NetworkByteOrderNumberUtil.intToFourByte(tmplong);
            this.buf.put(fourbytes[1]);
            this.buf.put(fourbytes[2]);
            this.buf.put(fourbytes[3]);
        } else {
            this.buf.put((byte)h.getAssuredCtrlVersion());
            this.buf.put((byte)h.getMsgType());
            byte[] fourbytes = NetworkByteOrderNumberUtil.intToFourByte(h.getSmfEncodedLength());
            this.buf.put(fourbytes[0]);
            this.buf.put(fourbytes[1]);
            this.buf.put(fourbytes[2]);
            this.buf.put(fourbytes[3]);
        }
        if (h.getEncodedParamsLen() > 0) {
            int param_sz = h.getEncodedParamsLen();
            this.buf.ensureObjectFit(param_sz);
            this.buf.put(h.getParamContainer().getBuffer(), 0, param_sz);
        } else {
            SmfTLVParameter[] paramArray = h.getParams();
            this.buf.ensureObjectFit(h.getSmfEncodedLength());
            for (int i = 0; i < paramArray.length; ++i) {
                SmfTLVParameter param = paramArray[i];
                TlvCoderUtil.writeTlvParamAssuredCtrl(this.buf, param);
            }
        }
        int position = this.buf.position();
        while (position++ % 4 != 0) {
            this.buf.put((byte)0);
        }
        this.buf.flip();
        byte[] assuredData = new byte[this.buf.limit()];
        this.buf.get(assuredData);
        out.write(assuredData);
        out.flush();
    }
}

