/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.nio.impl;

import com.solacesystems.jcsmp.JCSMPSessionStats;
import com.solacesystems.jcsmp.i18n.JCSMPRB;
import com.solacesystems.jcsmp.impl.compression.BufferUtil;
import com.solacesystems.jcsmp.impl.compression.SolZlibCallResult;
import com.solacesystems.jcsmp.impl.compression.SolZlibDeflatePipe;
import com.solacesystems.jcsmp.protocol.nio.SubscriberWireMessageHandler;
import com.solacesystems.jcsmp.protocol.nio.impl.SubscriberMessageReader;
import com.solacesystems.jcsmp.statistics.StatType;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;

public class ZlibSubscriberMessageReader
extends SubscriberMessageReader {
    private SolZlibDeflatePipe z_in;
    ByteBuffer _tempBuf = ByteBuffer.allocate(64000);

    public ZlibSubscriberMessageReader(ByteChannel byteChannel, SubscriberWireMessageHandler callbackHandler, SolZlibDeflatePipe zlibpipe, boolean genRxTimestamps, JCSMPSessionStats sessionstats) {
        super(byteChannel, callbackHandler, genRxTimestamps, sessionstats);
        this.z_in = zlibpipe;
    }

    protected void drainSocketData() throws IOException {
        this._bytesLastDrain = 0;
        int totalDecompressed = 0;
        int cnt = 0;
        ByteChannel s = (ByteChannel)((Object)this.getChannel());
        this._tempBuf.clear();
        cnt = s.read(this._tempBuf);
        if (cnt > 0) {
            this._bytesLastDrain += cnt;
            this._tempBuf.flip();
            int inSz = this._tempBuf.remaining();
            byte[] zlibdata = this._tempBuf.array();
            byte[] infl_data = new byte[inSz * 4];
            int consumed = 0;
            int decompressed = 0;
            boolean done = false;
            while (!done) {
                SolZlibCallResult ret = this.z_in.inflateChunks(zlibdata, consumed, inSz, infl_data, decompressed, infl_data.length);
                if (ret.bytes_output == -1) {
                    throw new IOException(JCSMPRB.BUNDLE.getStringSafely("Zlib.streamError"));
                }
                consumed += ret.bytes_consumed;
                if ((decompressed += ret.bytes_output) == infl_data.length) {
                    infl_data = BufferUtil.growBuffer(infl_data, infl_data.length, infl_data.length * 2);
                    continue;
                }
                if (ret.bytes_consumed != 0 || ret.bytes_output != 0) continue;
                done = true;
            }
            int room = this._inputBuf.remaining();
            if (decompressed > room) {
                int newSz = decompressed - room + this._inputBuf.capacity();
                this._inputBuf.flip();
                this.resizeBuffer(newSz);
            }
            this._inputBuf.put(infl_data, 0, decompressed);
            totalDecompressed += decompressed;
            this._tempBuf.clear();
        }
        if (cnt < 0) {
            this.closeChannel();
        }
        this._sessionStats.incStat(StatType.TOTAL_SOCKET_BYTES_RECVED, totalDecompressed);
        this._sessionStats.incStat(StatType.TOTAL_SOCKET_COMPRESSED_BYTES_RECVED, this._bytesLastDrain);
    }
}

