/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl;

import com.solacesystems.common.util.DestinationUtil;
import com.solacesystems.jcsmp.Queue;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public class QueueImpl
extends Queue
implements Serializable {
    private static final long serialVersionUID = -4646347040369656540L;
    private static final int TRM_DURABLEQUEUE_NAME_OFFSET = "#P2P/QUE/".length();

    protected QueueImpl(String name, boolean durable) {
        super(name, durable);
    }

    protected QueueImpl(String name, boolean durable, String hostId) {
        super(name, durable, hostId);
    }

    public String getNamePartInternal() {
        return this.name;
    }

    public static Queue createFastNoValidation(String name) {
        QueueImpl ret_queue = null;
        if (name.startsWith("#P2P/QTMP")) {
            ret_queue = new QueueImpl(name, false);
        } else if (name.startsWith("#P2P/QUE")) {
            char c;
            StringBuilder hostIdBuilder = new StringBuilder();
            int i = TRM_DURABLEQUEUE_NAME_OFFSET;
            while (i < name.length() && (c = name.charAt(i++)) != '/') {
                hostIdBuilder.append(c);
            }
            ret_queue = i == name.length() ? new QueueImpl(hostIdBuilder.toString(), true) : new QueueImpl(name.substring(i), true, hostIdBuilder.toString());
        } else {
            ret_queue = new QueueImpl(name, true);
        }
        return ret_queue;
    }

    public static Queue createFromIncomingTrMsg(String name, int q_offset, int q_len) {
        QueueImpl ret_queue = null;
        if (name.startsWith("#P2P/QTMP")) {
            ret_queue = new QueueImpl(name, false);
        } else if (name.startsWith("#P2P/QUE")) {
            if (q_offset > TRM_DURABLEQUEUE_NAME_OFFSET) {
                String qname = name.substring(q_offset);
                String hostId = name.substring(TRM_DURABLEQUEUE_NAME_OFFSET, q_offset - 1);
                ret_queue = new QueueImpl(qname, true, hostId);
            } else {
                ret_queue = new QueueImpl(name.substring(TRM_DURABLEQUEUE_NAME_OFFSET), true);
            }
        } else {
            ret_queue = new QueueImpl(name, true);
        }
        return ret_queue;
    }

    public static Queue userCreateWithInit(String name, boolean durability) {
        return QueueImpl.userCreateWithInit(name, durability, null);
    }

    public static Queue userCreateWithInit(String name, boolean durability, String hostId) {
        return QueueImpl.createWithInit(name, durability, hostId);
    }

    public static Queue createWithInit(String name, boolean durability) {
        return QueueImpl.createWithInit(name, durability, null);
    }

    public static Queue createWithInit(String name, boolean durability, String hostId) {
        QueueImpl q = null;
        q = name.startsWith("#P2P") ? (QueueImpl)QueueImpl.createFastNoValidation(name) : new QueueImpl(name, durability, hostId);
        q.validateCommon();
        q.init();
        return q;
    }

    private void initTrmDestOffsets() {
        this.getTrmTopicRepresentation();
        this.trmDestOffset = 0;
        this.trmDestLength = this.trmTopicBytes.length - 1 - this.trmDestOffset;
    }

    protected int getTrmDestOffset() {
        if (this.trmDestLength == 0) {
            this.initTrmDestOffsets();
        }
        return this.trmDestOffset;
    }

    protected int getTrmDestLength() {
        if (this.trmDestLength == 0) {
            this.initTrmDestOffsets();
        }
        return this.trmDestLength;
    }

    protected byte[] getTrmTopicRepresentation() {
        if (this.trmTopicBytes == null) {
            byte[] tmpTrmTopicBytes = null;
            try {
                if (this.isDurable()) {
                    String strTrmTopic = DestinationUtil.createDurQueueTrbTopic(this.name, this.hostId);
                    tmpTrmTopicBytes = strTrmTopic.getBytes("UTF-8");
                } else {
                    tmpTrmTopicBytes = this.name.getBytes("UTF-8");
                }
            }
            catch (UnsupportedEncodingException e) {
                tmpTrmTopicBytes = new byte[]{};
            }
            byte[] tmpTrmTopicBytes2 = new byte[tmpTrmTopicBytes.length + 1];
            System.arraycopy(tmpTrmTopicBytes, 0, tmpTrmTopicBytes2, 0, tmpTrmTopicBytes.length);
            this.trmTopicBytes = tmpTrmTopicBytes2;
        }
        return this.trmTopicBytes;
    }
}

