/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl;

import com.solacesystems.jcsmp.JCSMPFactory;
import com.solacesystems.jcsmp.Topic;
import com.solacesystems.jcsmp.protocol.impl.InetAddressUtil;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class P2pUtil {
    private static final Log Trace = LogFactory.getLog(P2pUtil.class);

    public static Topic getP2pInboxTopic(String base) {
        return JCSMPFactory.onlyInstance().createTopic(base + "/#");
    }

    public static Topic getP2pTopicSubscription(String base) {
        return JCSMPFactory.onlyInstance().createTopic(base + "/>");
    }

    public static String getGeneratedP2pTopicBase(String username, String host, String hostProvidedVridStr) {
        String ip_hexstring = null;
        ip_hexstring = hostProvidedVridStr != null ? hostProvidedVridStr : P2pUtil.getVridHex(host);
        return String.format("#P2P/%s/%s", ip_hexstring, username);
    }

    public static String getVridHex(String host) {
        String NULL_HEX_IP = "00000000";
        String ip_hexstring = "";
        try {
            String ip_string = InetAddressUtil.getIP(host);
            String[] ip_parts = ip_string.split("\\.");
            StringBuilder ip_hexstring_builder = new StringBuilder();
            for (String ip_part : ip_parts) {
                String hex = Integer.toHexString(Integer.parseInt(ip_part)).toUpperCase();
                ip_hexstring_builder.append(hex.length() == 1 ? "0" + hex : hex);
            }
            ip_hexstring = ip_hexstring_builder.toString();
        }
        catch (UnknownHostException uhe) {
            Trace.warn((Object)String.format("VRID generation: Unable to resolve host '%s', using '%s' for IP string", host, "00000000"));
            ip_hexstring = "00000000";
        }
        catch (Exception ex) {
            Trace.warn((Object)String.format("VRID generation: Exception %s, using '%s' for IP string", ex.toString(), "00000000"));
            ip_hexstring = "00000000";
        }
        return ip_hexstring;
    }
}

