/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.util.notification;

import java.util.Timer;

public interface NotificationPolicy {
    public static final int DEFAULT_DELAY = 200;

    public boolean enqueue();

    public long getTimeout();

    public Timer getTimer();

    public int getCurrent();

    public int getThreshold();

    public void reset();

    public static class ThrottledNotificationPolicy
    implements NotificationPolicy {
        private int m_threshold;
        private int m_currentCount;
        private long m_timeout;
        private static final Timer m_theTimer = new Timer(true);

        public ThrottledNotificationPolicy() {
            this.m_threshold = 2000;
            this.m_timeout = 1000L;
        }

        public ThrottledNotificationPolicy(int threshold, long timeout) {
            this.m_threshold = threshold;
            this.m_timeout = timeout;
        }

        public synchronized boolean enqueue() {
            boolean trigger = ++this.m_currentCount > this.m_threshold;
            this.m_currentCount = trigger ? 0 : this.m_currentCount;
            return trigger;
        }

        public Timer getTimer() {
            return m_theTimer;
        }

        public void reset() {
            this.m_currentCount = 0;
        }

        public long getTimeout() {
            return this.m_timeout;
        }

        public int getCurrent() {
            return this.m_currentCount;
        }

        public int getThreshold() {
            return this.m_threshold;
        }
    }
}

