/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.util;

import com.solacesystems.common.util.AbstractCipherTool;
import com.solacesystems.common.util.Base64;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;

public class CmdLineCipherTool
extends AbstractCipherTool {
    private static final byte[] default_sk = new byte[]{4, -88, 51, 13, 9, 18, 127, -50, 91, -49, -93, 19, -128, 75, 41, 55};
    private static final byte[] default_ek = new byte[]{126, 5, -14, 43, -40, -114, 21, -68, 28, 6, -51, -53, 105, 79, -75, 117, -4, -99, -71, -120, 15, -38, 52, 86, 24, 50, 123, -16, -50, -87, 126, 119};
    private final byte[] ek;

    public CmdLineCipherTool() throws GeneralSecurityException {
        this(default_sk, default_ek);
    }

    public CmdLineCipherTool(byte[] sk, byte[] ek) throws GeneralSecurityException {
        super(sk);
        this.ek = ek;
    }

    byte[] getEk() {
        return this.ek;
    }

    public String prepare_property(String someString) {
        if (someString == null) {
            throw new IllegalArgumentException("Please provide a non null input");
        }
        try {
            return Base64.encodeBytes(this.encrypt(someString.getBytes(Charset.forName("UTF-8"))), 8);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Sorry I was unable to encrypt [" + someString + "]", e);
        }
    }

    protected void encrypt_string(String[] args) {
        String password = this.readPassword("Password: ");
        String verify_password = this.readPassword("Verify Password: ");
        if (password != null && password.length() > 0 && verify_password != null && verify_password.equals(password)) {
            System.out.println("Encrypted:");
            System.out.println(this.prepare_property(password));
        } else {
            System.err.println("Empty password or passwords did not match");
        }
    }

    public static void main(String[] args) {
        try {
            CmdLineCipherTool instance = new CmdLineCipherTool();
            instance.encrypt_string(args);
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
    }

    protected String readPassword(String prompt) {
        try {
            Class<?> consoleClazz = Class.forName("java.io.Console");
            Method m = System.class.getDeclaredMethod("console", null);
            m.setAccessible(true);
            Object consoleObj = m.invoke((Object)null, new Object[0]);
            Method readPasswordMethod = consoleClazz.getDeclaredMethod("readPassword", null);
            readPasswordMethod.setAccessible(true);
            System.out.print(prompt);
            char[] passChars = (char[])readPasswordMethod.invoke(consoleObj, new Object[0]);
            return new String(passChars);
        }
        catch (Throwable t) {
            MaskingThread et = new MaskingThread(prompt);
            Thread mask = new Thread(et);
            mask.start();
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in, Charset.forName("UTF-8")));
            String password = "";
            try {
                password = in.readLine();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            et.stopMasking();
            return password;
        }
    }

    private class MaskingThread
    implements Runnable {
        private boolean stop;

        public MaskingThread(String prompt) {
            System.out.print(prompt);
        }

        public void run() {
            this.stop = true;
            while (this.stop) {
                System.out.print("\b*");
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
            }
        }

        public void stopMasking() {
            this.stop = false;
        }
    }
}

