/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.smf;

import com.solacesystems.jcsmp.impl.QueueImpl;
import com.solacesystems.jcsmp.impl.TopicImpl;
import com.solacesystems.jcsmp.protocol.smf.AbstractHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.impl.TlvCoderUtil;

public class SmpHeaderBean
extends AbstractHeaderBean {
    public static final int SMP_ADDSUBSCRIPTION = 0;
    public static final int SMP_REMSUBSCRIPTION = 1;
    public static final int SMP_ADD_QUEUE_SUBSCRIPTION = 2;
    public static final int SMP_REM_QUEUE_SUBSCRIPTION = 3;
    public static final int SMP_ADD_SUBSCRIPTION_FOR_CLIENTNAME = 4;
    public static final int SMP_REM_SUBSCRIPTION_FOR_CLIENTNAME = 5;
    public static final int SMP_FLAG_FILTER = 1;
    public static final int SMP_FLAG_PERSIST = 2;
    public static final int SMP_FLAG_TOPIC = 4;
    public static final int SMP_FLAG_RESPREQUIRED = 8;
    public static final int SMP_FLAG_DELIVER_ALWAYS = 16;
    private int smpMsgType;
    private int smpFlags;
    private byte[] encodedUtf8Subscription;
    private byte[] encodedQueueName;
    private byte[] encodedClientName;

    public SmpHeaderBean() {
        this.reset();
    }

    public final void reset() {
        super.reset();
        this.encodedUtf8Subscription = new byte[0];
        this.smpMsgType = 0;
        this.smpFlags = 12;
        this.encodedClientName = null;
        this.encodedQueueName = null;
    }

    public int getSmfEncodedLength() {
        int len = 6 + this.encodedUtf8Subscription.length;
        if (this.encodedQueueName != null) {
            len += this.encodedQueueName.length;
            ++len;
            ++len;
        }
        if (this.encodedClientName != null) {
            len += this.encodedClientName.length;
            ++len;
            ++len;
        }
        return len;
    }

    public int getSmpMsgType() {
        return this.smpMsgType;
    }

    public void setSmpMsgType(int smpMsgType) {
        this.smpMsgType = smpMsgType;
    }

    public int getSmpFlags() {
        return this.smpFlags;
    }

    public void setSmpFlags(int smpFlags) {
        this.smpFlags = smpFlags;
    }

    public byte[] getEncodedUtf8Subscription() {
        return this.encodedUtf8Subscription;
    }

    public void setEncodedUtf8Subscription(byte[] encodedUtf8Subscription) {
        this.encodedUtf8Subscription = encodedUtf8Subscription;
    }

    public void setEncodedQueueName(byte[] encodedQueueName) {
        this.encodedQueueName = encodedQueueName;
    }

    public byte[] getEncodedQueueName() {
        return this.encodedQueueName;
    }

    public byte[] getEncodedClientName() {
        return this.encodedClientName;
    }

    public void setEncodedClientName(byte[] encodedClientName) {
        this.encodedClientName = encodedClientName;
    }

    public static SmpHeaderBean createAddSubscriptionReq(TopicImpl t) {
        SmpHeaderBean smprequest = SmpHeaderBean.createSmpReq(t, null, null);
        smprequest.setSmpMsgType(0);
        return smprequest;
    }

    public static SmpHeaderBean createRemoveSubscriptionReq(TopicImpl t) {
        SmpHeaderBean smprequest = SmpHeaderBean.createSmpReq(t, null, null);
        smprequest.setSmpMsgType(1);
        return smprequest;
    }

    public static SmpHeaderBean createAddQueueSubscriptionReq(TopicImpl t, QueueImpl q) {
        SmpHeaderBean smprequest = SmpHeaderBean.createSmpReq(t, q, null);
        smprequest.setSmpMsgType(2);
        return smprequest;
    }

    public static SmpHeaderBean createRemoveQueueSubscriptionReq(TopicImpl t, QueueImpl q) {
        SmpHeaderBean smprequest = SmpHeaderBean.createSmpReq(t, q, null);
        smprequest.setSmpMsgType(3);
        return smprequest;
    }

    public static SmpHeaderBean createAddSubscriptionForClientNameReq(TopicImpl t, String clientName) {
        SmpHeaderBean smprequest = SmpHeaderBean.createSmpReq(t, null, clientName);
        smprequest.setSmpMsgType(4);
        return smprequest;
    }

    public static SmpHeaderBean createRemSubscriptionForClientNameReq(TopicImpl t, String clientName) {
        SmpHeaderBean smprequest = SmpHeaderBean.createSmpReq(t, null, clientName);
        smprequest.setSmpMsgType(5);
        return smprequest;
    }

    private static SmpHeaderBean createSmpReq(TopicImpl t, QueueImpl q, String forClientName) {
        byte[] topic_enc = t.getNameBytes();
        SmpHeaderBean smprequest = new SmpHeaderBean();
        smprequest.setEncodedUtf8Subscription(topic_enc);
        int smp_flag = t.isRxAllDeliverToOne() ? 16 : 0;
        smprequest.setSmpFlags(smprequest.getSmpFlags() | smp_flag);
        if (q != null) {
            assert (forClientName == null);
            String queueName = q.getNamePartInternal();
            byte[] encBytes = TlvCoderUtil.toNullTermUtf8(queueName);
            smprequest.setEncodedQueueName(encBytes);
        }
        if (forClientName != null) {
            assert (q == null);
            byte[] encBytes = TlvCoderUtil.toNullTermUtf8(forClientName);
            smprequest.setEncodedClientName(encBytes);
        }
        return smprequest;
    }
}

