/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.util.timers;

import com.solacesystems.common.util.timers.BeanThread;
import com.solacesystems.common.util.timers.TimeoutData;
import com.solacesystems.common.util.timers.TimeoutKey;
import com.solacesystems.common.util.timers.TimeoutListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class TimeoutManager
extends BeanThread {
    private boolean notifyBug = false;
    private static TimeoutManager onlyInstance = new TimeoutManager();
    private Thread me = new BeanThread(this);
    private static Hashtable<TimeoutKey, TimeoutData> pending = new Hashtable();
    private static Vector<TimeoutKey> callbackVector = new Vector();

    private TimeoutManager() {
        this.me.setName("Timeout Manager");
        this.me.setDaemon(true);
        this.me.start();
    }

    public void run() {
        while (true) {
            this.findNext();
            Enumeration<TimeoutKey> enumeration = callbackVector.elements();
            while (enumeration.hasMoreElements()) {
                TimeoutKey timeoutkey = enumeration.nextElement();
                TimeoutData timeoutdata = pending.remove(timeoutkey);
                if (timeoutdata == null) continue;
                timeoutkey.listener.timeout(timeoutkey.key, timeoutdata.id);
            }
            callbackVector.removeAllElements();
        }
    }

    private synchronized void findNext() {
        if (this.notifyBug) {
            this.notifyBug = false;
        }
        long l = -1L;
        long l1 = System.currentTimeMillis();
        Enumeration<TimeoutData> enumeration = pending.elements();
        Enumeration<TimeoutKey> enumeration1 = pending.keys();
        while (enumeration.hasMoreElements()) {
            TimeoutData timeoutdata = enumeration.nextElement();
            if (timeoutdata.stopTime <= l1) {
                TimeoutKey timeoutkey = enumeration1.nextElement();
                callbackVector.addElement(timeoutkey);
                continue;
            }
            long l3 = timeoutdata.stopTime - l1;
            if (l == -1L || l3 < l) {
                l = l3;
            }
            enumeration1.nextElement();
        }
        if (this.notifyBug || callbackVector.size() > 0) {
            this.notifyBug = false;
            return;
        }
        try {
            long l2 = 0L;
            if (l != -1L) {
                l2 = l;
            }
            this.wait(l2);
        }
        catch (InterruptedException interruptedexception) {
            // empty catch block
        }
    }

    private synchronized Object registerTO(TimeoutListener timeoutlistener, long l, Object obj) {
        TimeoutKey timeoutkey = new TimeoutKey(timeoutlistener, obj);
        pending.put(timeoutkey, new TimeoutData(l, timeoutkey));
        this.notifyThread();
        return timeoutkey;
    }

    private synchronized void notifyThread() {
        this.notifyBug = true;
        this.notify();
    }

    public static Object register(TimeoutListener timeoutlistener, int i) {
        return onlyInstance.registerTO(timeoutlistener, i * 1000, null);
    }

    public static Object registerMS(TimeoutListener timeoutlistener, long l) {
        return onlyInstance.registerTO(timeoutlistener, l, null);
    }

    public static Object register(TimeoutListener timeoutlistener, int i, Object obj) {
        return onlyInstance.registerTO(timeoutlistener, i * 1000, obj);
    }

    public static Object registerMS(TimeoutListener timeoutlistener, long l, Object obj) {
        return onlyInstance.registerTO(timeoutlistener, l, obj);
    }

    public static boolean cancel(Object obj) {
        if (obj != null) {
            return onlyInstance.cancelTO(obj);
        }
        return false;
    }

    private synchronized boolean cancelTO(Object obj) {
        return pending.remove(obj) != null;
    }
}

